/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.mysql;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.exception.EntityNotFoundException;
import monasca.api.domain.model.alarmdefinition.AlarmDefinition;
import monasca.api.domain.model.alarmdefinition.AlarmDefinitionRepo;
import monasca.api.infrastructure.persistence.DimensionQueries;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.infrastructure.persistence.SubAlarmDefinitionQueries;
import monasca.common.model.alarm.AggregateFunction;
import monasca.common.model.alarm.AlarmOperator;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.metric.MetricDefinition;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class AlarmDefinitionMySqlRepoImpl
implements AlarmDefinitionRepo {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final String SUB_ALARM_SQL = "select sa.*, sad.dimensions from sub_alarm_definition as sa left join (select sub_alarm_definition_id, group_concat(dimension_name, '=', value) as dimensions from sub_alarm_definition_dimension group by sub_alarm_definition_id ) as sad on sad.sub_alarm_definition_id = sa.id where sa.alarm_definition_id = :alarmDefId";
    private final DBI db;
    private final PersistUtils persistUtils;

    @Inject
    public AlarmDefinitionMySqlRepoImpl(@Named(value="mysql") DBI db, PersistUtils persistUtils) {
        this.db = db;
        this.persistUtils = persistUtils;
    }

    @Override
    public AlarmDefinition create(String tenantId, String id, String name, String description, String severity, String expression, Map<String, AlarmSubExpression> subExpressions, List<String> matchBy, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        try (Handle h = this.db.open();){
            h.begin();
            h.insert("insert into alarm_definition (id, tenant_id, name, description, severity, expression, match_by, actions_enabled, created_at, updated_at, deleted_at) values (?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW(), NULL)", new Object[]{id, tenantId, name, description, severity, expression, matchBy == null || Iterables.isEmpty(matchBy) ? null : COMMA_JOINER.join(matchBy), true});
            this.createSubExpressions(h, id, subExpressions);
            this.persistActions(h, id, AlarmState.ALARM, alarmActions);
            this.persistActions(h, id, AlarmState.OK, okActions);
            this.persistActions(h, id, AlarmState.UNDETERMINED, undeterminedActions);
            h.commit();
            AlarmDefinition alarmDefinition = new AlarmDefinition(id, name, description, severity, expression, matchBy, true, alarmActions, okActions == null ? Collections.emptyList() : okActions, undeterminedActions == null ? Collections.emptyList() : undeterminedActions);
            return alarmDefinition;
        }
    }

    @Override
    public void deleteById(String tenantId, String alarmDefId) {
        try (Handle h = this.db.open();){
            if (h.update("update alarm_definition set deleted_at = NOW() where tenant_id = ? and id = ? and deleted_at is NULL", new Object[]{tenantId, alarmDefId}) == 0) {
                throw new EntityNotFoundException("No alarm definition exists for %s", alarmDefId);
            }
            h.execute("delete from alarm where alarm_definition_id = :id", new Object[]{alarmDefId});
        }
    }

    @Override
    public String exists(String tenantId, String name) {
        try (Handle h = this.db.open();){
            Map map = (Map)((Query)((Query)h.createQuery("select id from alarm_definition where tenant_id = :tenantId and name = :name and deleted_at is NULL").bind("tenantId", tenantId)).bind("name", name)).first();
            if (map != null) {
                if (map.values().size() != 0) {
                    String string = map.get("id").toString();
                    return string;
                }
                String string = null;
                return string;
            }
            String string = null;
            return string;
        }
    }

    @Override
    public List<AlarmDefinition> find(String tenantId, String name, Map<String, String> dimensions, String offset, int limit) {
        try (Handle h = this.db.open();){
            List resultSet;
            String query = "  SELECT t.id, t.tenant_id, t.name, t.description, t.expression, t.severity, t.match_by,     t.actions_enabled, t.created_at, t.updated_at, t.deleted_at,      GROUP_CONCAT(aa.alarm_state) AS states,      GROUP_CONCAT(aa.action_id) AS notificationIds FROM (SELECT distinct ad.id, ad.tenant_id, ad.name, ad.description, ad.expression,        ad.severity, ad.match_by, ad.actions_enabled, ad.created_at,         ad.updated_at, ad.deleted_at       FROM alarm_definition AS ad       LEFT OUTER JOIN sub_alarm_definition AS sad ON ad.id = sad.alarm_definition_id       LEFT OUTER JOIN sub_alarm_definition_dimension AS dim ON sad.id = dim.sub_alarm_definition_id %1$s       WHERE ad.tenant_id = :tenantId AND ad.deleted_at IS NULL %2$s %3$s) AS t LEFT OUTER JOIN alarm_action AS aa ON t.id = aa.alarm_definition_id GROUP BY t.id ORDER BY t.id, t.created_at";
            StringBuilder sbWhere = new StringBuilder();
            if (name != null) {
                sbWhere.append(" and ad.name = :name");
            }
            if (offset != null) {
                sbWhere.append(" and ad.id > :offset");
            }
            String limitPart = "";
            if (limit > 0) {
                limitPart = " limit :limit";
            }
            String sql = String.format(query, SubAlarmDefinitionQueries.buildJoinClauseFor(dimensions), sbWhere, limitPart);
            Query q = h.createQuery(sql);
            q.bind("tenantId", tenantId);
            if (name != null) {
                q.bind("name", name);
            }
            if (offset != null) {
                q.bind("offset", offset);
            }
            if (limit > 0) {
                q.bind("limit", limit + 1);
            }
            q.registerMapper((ResultSetMapper)new AlarmDefinitionMapper());
            q = q.mapTo(AlarmDefinition.class);
            DimensionQueries.bindDimensionsToQuery(q, dimensions);
            List list = resultSet = q.list();
            return list;
        }
    }

    @Override
    public AlarmDefinition findById(String tenantId, String alarmDefId) {
        try (Handle h = this.db.open();){
            String query = "SELECT alarm_definition.id, alarm_definition.tenant_id, alarm_definition.name, alarm_definition.description, alarm_definition.expression, alarm_definition.severity, alarm_definition.match_by, alarm_definition.actions_enabled,  alarm_definition.created_at, alarm_definition.updated_at, alarm_definition.deleted_at, GROUP_CONCAT(alarm_action.action_id) AS notificationIds,group_concat(alarm_action.alarm_state) AS states FROM alarm_definition LEFT OUTER JOIN alarm_action ON alarm_definition.id=alarm_action.alarm_definition_id  WHERE alarm_definition.tenant_id=:tenantId AND alarm_definition.id=:alarmDefId AND alarm_definition.deleted_at  IS NULL GROUP BY alarm_definition.id";
            Query q = h.createQuery(query);
            q.bind("tenantId", tenantId);
            q.bind("alarmDefId", alarmDefId);
            q.registerMapper((ResultSetMapper)new AlarmDefinitionMapper());
            q = q.mapTo(AlarmDefinition.class);
            AlarmDefinition alarmDefinition = (AlarmDefinition)q.first();
            if (alarmDefinition == null) {
                throw new EntityNotFoundException("No alarm definition exists for %s", alarmDefId);
            }
            AlarmDefinition alarmDefinition2 = alarmDefinition;
            return alarmDefinition2;
        }
    }

    @Override
    public Map<String, MetricDefinition> findSubAlarmMetricDefinitions(String alarmDefId) {
        try (Handle h = this.db.open();){
            List rows = ((Query)h.createQuery(SUB_ALARM_SQL).bind("alarmDefId", alarmDefId)).list();
            HashMap<String, MetricDefinition> subAlarmMetricDefs = new HashMap<String, MetricDefinition>();
            for (Map row : rows) {
                String id = (String)row.get("id");
                String metricName = (String)row.get("metric_name");
                Map<String, String> dimensions = DimensionQueries.dimensionsFor((String)row.get("dimensions"));
                subAlarmMetricDefs.put(id, new MetricDefinition(metricName, dimensions));
            }
            HashMap<String, MetricDefinition> hashMap = subAlarmMetricDefs;
            return hashMap;
        }
    }

    @Override
    public Map<String, AlarmSubExpression> findSubExpressions(String alarmDefId) {
        try (Handle h = this.db.open();){
            List rows = ((Query)h.createQuery(SUB_ALARM_SQL).bind("alarmDefId", alarmDefId)).list();
            HashMap<String, AlarmSubExpression> subExpressions = new HashMap<String, AlarmSubExpression>();
            for (Map row : rows) {
                String id = (String)row.get("id");
                AggregateFunction function = AggregateFunction.fromJson((String)((String)row.get("function")));
                String metricName = (String)row.get("metric_name");
                AlarmOperator operator = AlarmOperator.fromJson((String)((String)row.get("operator")));
                Double threshold = (Double)row.get("threshold");
                Integer period = (Integer)row.get("period");
                Integer periods = (Integer)row.get("periods");
                Map<String, String> dimensions = DimensionQueries.dimensionsFor((String)row.get("dimensions"));
                subExpressions.put(id, new AlarmSubExpression(function, new MetricDefinition(metricName, dimensions), operator, threshold.doubleValue(), period.intValue(), periods.intValue()));
            }
            HashMap<String, AlarmSubExpression> hashMap = subExpressions;
            return hashMap;
        }
    }

    @Override
    public void update(String tenantId, String id, boolean patch, String name, String description, String expression, List<String> matchBy, String severity, boolean actionsEnabled, Collection<String> oldSubAlarmIds, Map<String, AlarmSubExpression> changedSubAlarms, Map<String, AlarmSubExpression> newSubAlarms, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        try (Handle h = this.db.open();){
            h.begin();
            h.insert("update alarm_definition set name = ?, description = ?, expression = ?, match_by = ?, severity = ?, actions_enabled = ?, updated_at = NOW() where tenant_id = ? and id = ?", new Object[]{name, description, expression, matchBy == null || Iterables.isEmpty(matchBy) ? null : COMMA_JOINER.join(matchBy), severity, actionsEnabled, tenantId, id});
            if (oldSubAlarmIds != null) {
                for (String string : oldSubAlarmIds) {
                    h.execute("delete from sub_alarm_definition where id = ?", new Object[]{string});
                }
            }
            if (changedSubAlarms != null) {
                for (Map.Entry entry : changedSubAlarms.entrySet()) {
                    AlarmSubExpression sa = (AlarmSubExpression)entry.getValue();
                    h.execute("update sub_alarm_definition set operator = ?, threshold = ?, updated_at = NOW() where id = ?", new Object[]{sa.getOperator().name(), sa.getThreshold(), entry.getKey()});
                }
            }
            this.createSubExpressions(h, id, newSubAlarms);
            if (patch) {
                this.deleteActions(h, id, AlarmState.ALARM, alarmActions);
                this.deleteActions(h, id, AlarmState.OK, okActions);
                this.deleteActions(h, id, AlarmState.UNDETERMINED, undeterminedActions);
            } else {
                h.execute("delete from alarm_action where alarm_definition_id = ?", new Object[]{id});
            }
            this.persistActions(h, id, AlarmState.ALARM, alarmActions);
            this.persistActions(h, id, AlarmState.OK, okActions);
            this.persistActions(h, id, AlarmState.UNDETERMINED, undeterminedActions);
            h.commit();
        }
    }

    private void deleteActions(Handle handle, String id, AlarmState alarmState, List<String> actions) {
        if (actions != null) {
            handle.execute("delete from alarm_action where alarm_definition_id = ? and alarm_state = ?", new Object[]{id, alarmState.name()});
        }
    }

    private void persistActions(Handle handle, String id, AlarmState alarmState, List<String> actions) {
        if (actions != null) {
            for (String action : actions) {
                handle.insert("insert into alarm_action values (?, ?, ?)", new Object[]{id, alarmState.name(), action});
            }
        }
    }

    private void createSubExpressions(Handle handle, String id, Map<String, AlarmSubExpression> alarmSubExpressions) {
        if (alarmSubExpressions != null) {
            for (Map.Entry<String, AlarmSubExpression> subEntry : alarmSubExpressions.entrySet()) {
                String subAlarmId = subEntry.getKey();
                AlarmSubExpression subExpr = subEntry.getValue();
                MetricDefinition metricDef = subExpr.getMetricDefinition();
                handle.insert("insert into sub_alarm_definition (id, alarm_definition_id, function, metric_name, operator, threshold, period, periods, created_at, updated_at) values (?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())", new Object[]{subAlarmId, id, subExpr.getFunction().name(), metricDef.name, subExpr.getOperator().name(), subExpr.getThreshold(), subExpr.getPeriod(), subExpr.getPeriods()});
                if (metricDef.dimensions == null || metricDef.dimensions.isEmpty()) continue;
                for (Map.Entry dimEntry : metricDef.dimensions.entrySet()) {
                    handle.insert("insert into sub_alarm_definition_dimension values (?, ?, ?)", new Object[]{subAlarmId, dimEntry.getKey(), dimEntry.getValue()});
                }
            }
        }
    }

    private static class AlarmDefinitionMapper
    implements ResultSetMapper<AlarmDefinition> {
        private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();

        private AlarmDefinitionMapper() {
        }

        public AlarmDefinition map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            String notificationIds = r.getString("notificationIds");
            String states = r.getString("states");
            String matchBy = r.getString("match_by");
            List<String> notifications = this.splitStringIntoList(notificationIds);
            List<String> state = this.splitStringIntoList(states);
            List<String> match = this.splitStringIntoList(matchBy);
            ArrayList<String> okActionIds = new ArrayList<String>();
            ArrayList<String> alarmActionIds = new ArrayList<String>();
            ArrayList<String> undeterminedActionIds = new ArrayList<String>();
            int stateAndActionIndex = 0;
            for (String singleState : state) {
                if (singleState.equals(AlarmState.UNDETERMINED.name())) {
                    undeterminedActionIds.add(notifications.get(stateAndActionIndex));
                }
                if (singleState.equals(AlarmState.OK.name())) {
                    okActionIds.add(notifications.get(stateAndActionIndex));
                }
                if (singleState.equals(AlarmState.ALARM.name())) {
                    alarmActionIds.add(notifications.get(stateAndActionIndex));
                }
                ++stateAndActionIndex;
            }
            return new AlarmDefinition(r.getString("id"), r.getString("name"), r.getString("description"), r.getString("severity"), r.getString("expression"), match, r.getBoolean("actions_enabled"), alarmActionIds, okActionIds, undeterminedActionIds);
        }

        private List<String> splitStringIntoList(String commaDelimitedString) {
            if (commaDelimitedString == null) {
                return new ArrayList<String>();
            }
            Iterable split = COMMA_SPLITTER.split((CharSequence)commaDelimitedString);
            return Lists.newArrayList((Iterable)split);
        }
    }
}

