/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.vertica;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.model.metric.MetricDefinitionRepo;
import monasca.api.domain.model.metric.MetricName;
import monasca.api.infrastructure.persistence.DimensionQueries;
import monasca.api.infrastructure.persistence.vertica.MetricQueries;
import monasca.common.model.metric.MetricDefinition;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class MetricDefinitionVerticaRepoImpl
implements MetricDefinitionRepo {
    private static final String FIND_BY_METRIC_DEF_SQL = "select dd.id, def.name, d.name as dname, d.value as dvalue from MonMetrics.Definitions def, MonMetrics.DefinitionDimensions dd left outer join MonMetrics.Dimensions d on d.dimension_set_id = dd.dimension_set_id%s where def.id = dd.definition_id and def.tenant_id = :tenantId%s order by dd.id";
    private final DBI db;

    @Inject
    public MetricDefinitionVerticaRepoImpl(@Named(value="vertica") DBI db) {
        this.db = db;
    }

    @Override
    public List<MetricDefinition> find(String tenantId, String name, Map<String, String> dimensions, String offset, int limit) {
        try (Handle h = this.db.open();){
            StringBuilder sbWhere = new StringBuilder();
            if (name != null) {
                sbWhere.append(" and def.name = :name");
            }
            String sql = String.format(FIND_BY_METRIC_DEF_SQL, MetricQueries.buildJoinClauseFor(dimensions), sbWhere);
            Query query = (Query)h.createQuery(sql).bind("tenantId", tenantId);
            if (name != null) {
                query.bind("name", name);
            }
            DimensionQueries.bindDimensionsToQuery(query, dimensions);
            List rows = query.list();
            ArrayList<MetricDefinition> metricDefs = new ArrayList<MetricDefinition>(rows.size());
            byte[] currentId = null;
            HashMap<String, String> dims = null;
            for (Map row : rows) {
                byte[] defId = (byte[])row.get("id");
                String metricName = (String)row.get("name");
                String dName = (String)row.get("dname");
                String dValue = (String)row.get("dvalue");
                if (defId == null || !Arrays.equals(currentId, defId)) {
                    currentId = defId;
                    dims = new HashMap<String, String>();
                    if (dName != null && dValue != null) {
                        dims.put(dName, dValue);
                    }
                    metricDefs.add(new MetricDefinition(metricName, dims));
                    continue;
                }
                dims.put(dName, dValue);
            }
            ArrayList<MetricDefinition> arrayList = metricDefs;
            return arrayList;
        }
    }

    @Override
    public List<MetricName> findNames(String tenantId, Map<String, String> dimensions, String offset, int limit) throws Exception {
        throw new NotImplementedException();
    }
}

