/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import monasca.api.resource.exception.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreAuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(PreAuthenticationFilter.class);

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        HttpServletResponse res = (HttpServletResponse)response;
        ErrorCapturingServletResponseWrapper responseWrapper = new ErrorCapturingServletResponseWrapper(res);
        boolean caughtException = false;
        ServletOutputStream out = null;
        try {
            out = res.getOutputStream();
            chain.doFilter(request, (ServletResponse)responseWrapper);
            if (responseWrapper.statusCode != 401 && responseWrapper.statusCode != 500) {
                return;
            }
        }
        catch (Exception e) {
            LOG.error("Error while executing pre authentication filter", (Throwable)e);
            caughtException = true;
        }
        try {
            res.setContentType("application/json");
            if (caughtException) {
                res.setStatus(500);
            } else {
                res.setStatus(responseWrapper.statusCode);
                Exceptions.FaultType faultType = responseWrapper.statusCode == 500 ? Exceptions.FaultType.SERVER_ERROR : Exceptions.FaultType.UNAUTHORIZED;
                String output = Exceptions.buildLoggedErrorMessage(faultType, responseWrapper.errorMessage, null, responseWrapper.exception);
                out.print(output);
            }
        }
        catch (IllegalArgumentException e) {
            try {
                String output = Exceptions.buildLoggedErrorMessage(Exceptions.FaultType.UNAUTHORIZED, "invalid authToken", null, responseWrapper.exception);
                out.print(output);
            }
            catch (Exception x) {
                LOG.error("Error while writing failed authentication HTTP response", (Throwable)x);
            }
        }
        catch (Exception e) {
            LOG.error("Error while writing failed authentication HTTP response", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    static class ErrorCapturingServletResponseWrapper
    extends HttpServletResponseWrapper {
        private int statusCode;
        private String errorMessage;
        private Exception exception;

        public ErrorCapturingServletResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int statusCode) throws IOException {
            this.statusCode = statusCode;
        }

        public void sendError(int statusCode, String msg) throws IOException {
            this.statusCode = statusCode;
            this.errorMessage = msg;
        }

        void sendError(int statusCode, String msg, Exception exception) throws IOException {
            this.sendError(statusCode, msg);
            this.exception = exception;
        }
    }
}

