/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.app.AlarmService;
import monasca.api.app.command.UpdateAlarmCommand;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.alarm.Alarm;
import monasca.api.domain.model.alarm.AlarmRepo;
import monasca.api.domain.model.alarmstatehistory.AlarmStateHistoryRepo;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.resource.Links;
import monasca.api.resource.annotation.PATCH;
import monasca.common.model.alarm.AlarmState;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;

@Path(value="/v2.0/alarms")
public class AlarmResource {
    private final AlarmService service;
    private final AlarmRepo repo;
    private final PersistUtils persistUtils;
    private final AlarmStateHistoryRepo stateHistoryRepo;

    @Inject
    public AlarmResource(AlarmService service, AlarmRepo repo, AlarmStateHistoryRepo stateHistoryRepo, PersistUtils persistUtils) {
        this.service = service;
        this.repo = repo;
        this.stateHistoryRepo = stateHistoryRepo;
        this.persistUtils = persistUtils;
    }

    @DELETE
    @Timed
    @Path(value="/{alarm_id}")
    public void delete(@HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_id") String alarmId) {
        this.service.delete(tenantId, alarmId);
    }

    @GET
    @Timed
    @Path(value="/{alarm_id}")
    @Produces(value={"application/json"})
    public Alarm get(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_id") String alarm_id) {
        return this.fixAlarmLinks(uriInfo, this.repo.findById(tenantId, alarm_id));
    }

    private Alarm fixAlarmLinks(UriInfo uriInfo, Alarm alarm) {
        Links.hydrate(alarm.getAlarmDefinition(), uriInfo, "/v2.0/alarm-definitions");
        return Links.hydrate(alarm, uriInfo, true, new String[0]);
    }

    @GET
    @Timed
    @Path(value="/{alarm_id}/state-history")
    @Produces(value={"application/json"})
    public Object getStateHistory(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_id") String alarmId, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit) throws Exception {
        return Links.paginate(this.persistUtils.getLimit(limit), this.stateHistoryRepo.findById(tenantId, alarmId, offset, this.persistUtils.getLimit(limit)), uriInfo);
    }

    @GET
    @Timed
    @Path(value="/state-history")
    @Produces(value={"application/json"})
    public Object listStateHistory(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="dimensions") String dimensionsStr, @QueryParam(value="start_time") String startTimeStr, @QueryParam(value="end_time") String endTimeStr, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit) throws Exception {
        DateTime startTime = Validation.parseAndValidateDate(startTimeStr, "start_time", false);
        DateTime endTime = Validation.parseAndValidateDate(endTimeStr, "end_time", false);
        if (startTime != null) {
            Validation.validateTimes(startTime, endTime);
        }
        Map<String, String> dimensions = Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseAndValidateDimensions(dimensionsStr);
        return Links.paginate(this.persistUtils.getLimit(limit), this.stateHistoryRepo.find(tenantId, dimensions, startTime, endTime, offset, this.persistUtils.getLimit(limit)), uriInfo);
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object list(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="alarm_definition_id") String alarmDefId, @QueryParam(value="metric_name") String metricName, @QueryParam(value="metric_dimensions") String metricDimensionsStr, @QueryParam(value="state") AlarmState state, @QueryParam(value="state_updated_start_time") String stateUpdatedStartStr, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit) throws Exception {
        Map<String, String> metricDimensions = Strings.isNullOrEmpty((String)metricDimensionsStr) ? null : Validation.parseAndValidateNameAndDimensions(metricName, metricDimensionsStr, false);
        DateTime stateUpdatedStart = Validation.parseAndValidateDate(stateUpdatedStartStr, "state_updated_start_time", false);
        List<Alarm> alarms = this.repo.find(tenantId, alarmDefId, metricName, metricDimensions, state, stateUpdatedStart, offset, this.persistUtils.getLimit(limit), true);
        for (Alarm alarm : alarms) {
            Links.hydrate(alarm.getAlarmDefinition(), uriInfo, "/v2.0/alarm-definitions");
        }
        return Links.paginate(this.persistUtils.getLimit(limit), Links.hydrate(alarms, uriInfo, new String[0]), uriInfo);
    }

    @PATCH
    @Timed
    @Path(value="/{alarm_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Alarm patch(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_id") String alarmId, @NotEmpty Map<String, Object> fields) throws JsonMappingException {
        String stateStr = (String)fields.get("state");
        AlarmState state = stateStr == null ? null : Validation.parseAndValidate(AlarmState.class, stateStr);
        return this.fixAlarmLinks(uriInfo, this.service.patch(tenantId, alarmId, state));
    }

    @PUT
    @Timed
    @Path(value="/{alarm_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Alarm update(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_id") String alarmId, @Valid UpdateAlarmCommand command) {
        return this.fixAlarmLinks(uriInfo, this.service.update(tenantId, alarmId, command));
    }
}

