/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource.exception;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.common.base.Splitter;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import monasca.api.resource.exception.ErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Exceptions {
    private static final Logger LOG = LoggerFactory.getLogger(Exceptions.class);
    private static final ObjectMapper OBJECT_MAPPER;
    private static final Splitter LINE_SPLITTER;
    private static final Random RANDOM;

    private Exceptions() {
    }

    public static WebApplicationException badRequest(String msg, Object ... args) {
        return new WebAppException(FaultType.BAD_REQUEST, Exceptions.buildLoggedErrorMessage(FaultType.BAD_REQUEST, msg, args));
    }

    public static String buildLoggedErrorMessage(FaultType faultType, String message, Object ... args) {
        return Exceptions.buildLoggedErrorMessage(faultType, args == null || args.length == 0 ? message : String.format(message, args), null, null);
    }

    public static String buildLoggedErrorMessage(FaultType faultType, String message, @Nullable String details, @Nullable Throwable exception) {
        String errorCode = Long.toHexString(RANDOM.nextLong());
        if (faultType.loggable) {
            String withoutDetails = "{} {} - {}";
            String withDetails = "{} {} - {} {}";
            if (details == null) {
                if (exception == null) {
                    LOG.error(withoutDetails, new Object[]{faultType.name(), errorCode, message});
                } else {
                    LOG.error(withoutDetails, new Object[]{faultType.name(), errorCode, message, exception});
                }
            } else if (exception == null) {
                LOG.error(withDetails, new Object[]{faultType.name(), errorCode, message, details});
            } else {
                LOG.error(withDetails, new Object[]{faultType.name(), errorCode, message, details, exception});
            }
        }
        try {
            StringBuilder str = new StringBuilder("{\"");
            str.append(faultType.toString());
            str.append("\":");
            str.append(OBJECT_MAPPER.writeValueAsString((Object)new ErrorMessage(faultType.statusCode, message, details, errorCode)));
            str.append("}");
            return str.toString();
        }
        catch (JsonProcessingException bestEffort) {
            return null;
        }
    }

    public static WebApplicationException forbidden(String msg, Object ... args) {
        return new WebAppException(FaultType.FORBIDDEN, Exceptions.buildLoggedErrorMessage(FaultType.FORBIDDEN, msg, args));
    }

    public static String stripLocationFromStacktrace(String message) {
        Iterator i$ = LINE_SPLITTER.split((CharSequence)message).iterator();
        if (i$.hasNext()) {
            String s = (String)i$.next();
            return s;
        }
        return message;
    }

    public static WebApplicationException unprocessableEntity(String msg, Object ... args) {
        return new WebAppException(FaultType.UNPROCESSABLE_ENTITY, Exceptions.buildLoggedErrorMessage(FaultType.UNPROCESSABLE_ENTITY, msg, args));
    }

    public static WebApplicationException unprocessableEntityDetails(String msg, String details, Exception exception) {
        return new WebAppException(FaultType.UNPROCESSABLE_ENTITY, Exceptions.buildLoggedErrorMessage(FaultType.UNPROCESSABLE_ENTITY, msg, details, exception));
    }

    static {
        LINE_SPLITTER = Splitter.on((String)"\n").trimResults();
        RANDOM = new Random();
        OBJECT_MAPPER = new ObjectMapper();
        OBJECT_MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
    }

    private static class WebAppException
    extends WebApplicationException {
        private static final long serialVersionUID = 1L;

        public WebAppException(FaultType faultType, String message) {
            super(Response.status((int)faultType.statusCode).entity((Object)message).type("application/json").build());
        }
    }

    public static enum FaultType {
        SERVER_ERROR(Response.Status.INTERNAL_SERVER_ERROR, true),
        BAD_REQUEST(Response.Status.BAD_REQUEST, true),
        UNAUTHORIZED(Response.Status.UNAUTHORIZED, false),
        NOT_FOUND(Response.Status.NOT_FOUND, true),
        CONFLICT(Response.Status.CONFLICT, true),
        UNPROCESSABLE_ENTITY(422, true),
        FORBIDDEN(Response.Status.FORBIDDEN, true);

        public final int statusCode;
        public final boolean loggable;

        private FaultType(int statusCode, boolean loggable) {
            this.statusCode = statusCode;
            this.loggable = loggable;
        }

        private FaultType(Response.Status status, boolean loggable) {
            this.statusCode = status.getStatusCode();
            this.loggable = loggable;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

