/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app;

import java.util.Map;
import javax.inject.Inject;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import monasca.api.MonApiConfiguration;
import monasca.api.app.command.UpdateAlarmCommand;
import monasca.api.domain.exception.EntityNotFoundException;
import monasca.api.domain.exception.InvalidEntityException;
import monasca.api.domain.model.alarm.Alarm;
import monasca.api.domain.model.alarm.AlarmRepository;
import monasca.api.domain.model.alarmdefinition.AlarmDefinition;
import monasca.api.domain.model.alarmdefinition.AlarmDefinitionRepository;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.event.AlarmDeletedEvent;
import monasca.common.model.event.AlarmStateTransitionedEvent;
import monasca.common.model.event.AlarmUpdatedEvent;
import monasca.common.util.Exceptions;
import monasca.common.util.Serialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmService {
    private static final Logger LOG = LoggerFactory.getLogger(AlarmService.class);
    private final MonApiConfiguration config;
    private final Producer<String, String> producer;
    private final AlarmRepository repo;
    private final AlarmDefinitionRepository alarmDefRepo;
    private long messageCount = 0L;

    @Inject
    public AlarmService(MonApiConfiguration config, Producer<String, String> producer, AlarmRepository repo, AlarmDefinitionRepository alarmDefRepo) {
        this.config = config;
        this.producer = producer;
        this.repo = repo;
        this.alarmDefRepo = alarmDefRepo;
    }

    public void delete(String tenantId, String alarmId) {
        Alarm alarm = this.repo.findById(tenantId, alarmId);
        Map<String, AlarmSubExpression> subAlarmMetricDefs = this.repo.findAlarmSubExpressions(alarmId);
        this.repo.deleteById(tenantId, alarmId);
        String event = Serialization.toJson((Object)new AlarmDeletedEvent(tenantId, alarmId, alarm.getMetrics(), alarm.getAlarmDefinition().getId(), subAlarmMetricDefs));
        this.producer.send(new KeyedMessage(this.config.eventsTopic, (Object)String.valueOf(this.messageCount++), (Object)event));
    }

    public Alarm patch(String tenantId, String alarmId, AlarmState state) {
        if (state == null) {
            throw new InvalidEntityException("State must be specified");
        }
        Alarm alarm = this.updateInternal(tenantId, alarmId, state);
        return alarm;
    }

    public Alarm update(String tenantId, String alarmId, UpdateAlarmCommand command) {
        Alarm alarm = this.updateInternal(tenantId, alarmId, command.state);
        return alarm;
    }

    private String stateChangeReasonFor(AlarmState oldState, AlarmState newState) {
        return "Alarm state updated via API";
    }

    private Alarm updateInternal(String tenantId, String alarmId, AlarmState newState) {
        try {
            LOG.debug("Updating alarm {} for tenant {}", (Object)alarmId, (Object)tenantId);
            Alarm alarm = this.repo.update(tenantId, alarmId, newState);
            AlarmState oldState = alarm.getState();
            AlarmDefinition alarmDef = this.alarmDefRepo.findById(tenantId, alarm.getAlarmDefinition().getId());
            Map<String, AlarmSubExpression> subAlarms = this.repo.findAlarmSubExpressions(alarmId);
            String event = Serialization.toJson((Object)new AlarmUpdatedEvent(alarmId, alarmDef.getId(), tenantId, alarm.getMetrics(), subAlarms, newState, oldState));
            this.producer.send(new KeyedMessage(this.config.eventsTopic, (Object)String.valueOf(this.messageCount++), (Object)event));
            if (!oldState.equals((Object)newState)) {
                event = Serialization.toJson((Object)new AlarmStateTransitionedEvent(tenantId, alarmId, alarmDef.getId(), alarm.getMetrics(), alarmDef.getName(), alarmDef.getDescription(), oldState, newState, alarmDef.getSeverity(), alarmDef.isActionsEnabled(), this.stateChangeReasonFor(oldState, newState), System.currentTimeMillis() / 1000L));
                this.producer.send(new KeyedMessage(this.config.alarmStateTransitionsTopic, (Object)String.valueOf(this.messageCount++), (Object)event));
            }
            alarm.setState(newState);
            return alarm;
        }
        catch (EntityNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Exception)e, (String)"Error updating alarm for project / tenant %s", (Object[])new Object[]{tenantId});
        }
    }
}

