/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.command;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.constraints.Size;
import monasca.api.app.validation.DimensionValidation;
import monasca.api.app.validation.MetricNameValidation;
import monasca.api.resource.exception.Exceptions;
import monasca.common.model.metric.Metric;
import org.hibernate.validator.constraints.NotEmpty;

public class CreateMetricCommand {
    private static final long TIME_2MIN = 120L;
    private static final long TIME_2WEEKS = 1209600L;
    @NotEmpty
    @Size(min=1, max=64)
    public String name;
    public Map<String, String> dimensions;
    public long timestamp;
    public double value;
    public double[][] timeValues;

    public CreateMetricCommand() {
    }

    public CreateMetricCommand(String name, @Nullable Map<String, String> dimensions, @Nullable Long timestamp, double value) {
        this.setName(name);
        this.setDimensions(dimensions);
        this.setTimestamp(timestamp);
        this.value = value;
    }

    public CreateMetricCommand(String name, @Nullable Map<String, String> dimensions, @Nullable Long timestamp, double[][] timeValues) {
        this.setName(name);
        this.setDimensions(dimensions);
        this.setTimestamp(timestamp);
        this.timeValues = timeValues;
    }

    private static void validateTimestamp(long timestamp) {
        long time = System.currentTimeMillis() / 1000L;
        if (timestamp > time + 120L || timestamp < time - 1209600L) {
            throw Exceptions.unprocessableEntity("Timestamp %s is out of legal range", timestamp);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreateMetricCommand other = (CreateMetricCommand)obj;
        if (this.dimensions == null ? other.dimensions != null : !this.dimensions.equals(other.dimensions)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.timeValues, (Object[])other.timeValues)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dimensions == null ? 0 : this.dimensions.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + Arrays.deepHashCode((Object[])this.timeValues);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @JsonProperty
    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions == null || dimensions.isEmpty() ? null : DimensionValidation.normalize(dimensions);
    }

    @JsonProperty
    public void setName(String name) {
        this.name = MetricNameValidation.normalize(name);
    }

    @JsonProperty
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp == null || timestamp == 0L ? System.currentTimeMillis() / 1000L : timestamp;
    }

    public Metric toMetric() {
        return this.timeValues == null || this.timeValues.length == 0 ? new Metric(this.name, this.dimensions, this.timestamp, this.value) : new Metric(this.name, this.dimensions, this.timestamp, this.timeValues);
    }

    public void validate() {
        if (this.dimensions != null) {
            String service = this.dimensions.get("service");
            MetricNameValidation.validate(this.name, service);
            DimensionValidation.validate(this.dimensions, service);
        }
        CreateMetricCommand.validateTimestamp(this.timestamp);
        if (this.timeValues != null && this.timeValues.length > 0) {
            for (double[] timeValuePair : this.timeValues) {
                if (timeValuePair.length != 2) {
                    throw Exceptions.unprocessableEntity("All times_values must be timestamp / value pairs", new Object[0]);
                }
                CreateMetricCommand.validateTimestamp((long)timeValuePair[0]);
            }
        }
    }
}

