/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.validation;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import monasca.api.resource.exception.Exceptions;
import monasca.common.model.Services;

public class MetricNameValidation {
    private static final Pattern VALID_METRIC_NAME = Pattern.compile("^[a-zA-Z0-9_\\.\\-]+$");

    private MetricNameValidation() {
    }

    public static String normalize(String metricName) {
        return metricName == null ? null : CharMatcher.WHITESPACE.trimFrom((CharSequence)metricName);
    }

    public static void validate(String metricName, @Nullable String service) {
        if (Strings.isNullOrEmpty((String)metricName)) {
            throw Exceptions.unprocessableEntity("Metric name is required", new Object[0]);
        }
        if (metricName.length() > 64) {
            throw Exceptions.unprocessableEntity("Metric name %s must be 64 characters or less", metricName);
        }
        if (!Services.isReserved((String)metricName) && !VALID_METRIC_NAME.matcher(metricName).matches()) {
            throw Exceptions.unprocessableEntity("Metric name %s may only contain: a-z A-Z 0-9 _ - .", metricName);
        }
        if (service != null && Services.isReserved((String)service) && !Strings.isNullOrEmpty((String)metricName) && !Services.isValidMetricName((String)service, (String)metricName)) {
            throw Exceptions.unprocessableEntity("%s is not a valid metric name for namespace %s", metricName, service);
        }
    }
}

