/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import javax.inject.Singleton;
import monasca.api.MonApiConfiguration;
import monasca.api.domain.model.alarm.AlarmRepository;
import monasca.api.domain.model.alarmdefinition.AlarmDefinitionRepository;
import monasca.api.domain.model.alarmstatehistory.AlarmStateHistoryRepository;
import monasca.api.domain.model.measurement.MeasurementRepository;
import monasca.api.domain.model.metric.MetricDefinitionRepository;
import monasca.api.domain.model.notificationmethod.NotificationMethodRepository;
import monasca.api.domain.model.statistic.StatisticRepository;
import monasca.api.infrastructure.persistence.influxdb.AlarmStateHistoryInfluxDbRepositoryImpl;
import monasca.api.infrastructure.persistence.influxdb.MeasurementInfluxDbRepositoryImpl;
import monasca.api.infrastructure.persistence.influxdb.MetricDefinitionInfluxDbRepositoryImpl;
import monasca.api.infrastructure.persistence.influxdb.StatisticInfluxDbRepositoryImpl;
import monasca.api.infrastructure.persistence.mysql.AlarmDefinitionMySqlRepositoryImpl;
import monasca.api.infrastructure.persistence.mysql.AlarmMySqlRepositoryImpl;
import monasca.api.infrastructure.persistence.mysql.NotificationMethodMySqlRepositoryImpl;
import monasca.api.infrastructure.persistence.vertica.AlarmStateHistoryVerticaRepositoryImpl;
import monasca.api.infrastructure.persistence.vertica.MeasurementVerticaRepositoryImpl;
import monasca.api.infrastructure.persistence.vertica.MetricDefinitionVerticaRepositoryImpl;
import monasca.api.infrastructure.persistence.vertica.StatisticVerticaRepositoryImpl;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;

public class InfrastructureModule
extends AbstractModule {
    private MonApiConfiguration config;

    public InfrastructureModule(MonApiConfiguration config) {
        this.config = config;
    }

    protected void configure() {
        this.bind(AlarmRepository.class).to(AlarmMySqlRepositoryImpl.class).in(Singleton.class);
        this.bind(AlarmDefinitionRepository.class).to(AlarmDefinitionMySqlRepositoryImpl.class).in(Singleton.class);
        if (this.config.databaseConfiguration.getDatabaseType().trim().toLowerCase().equals("vertica")) {
            this.bind(AlarmStateHistoryRepository.class).to(AlarmStateHistoryVerticaRepositoryImpl.class).in(Singleton.class);
            this.bind(MetricDefinitionRepository.class).to(MetricDefinitionVerticaRepositoryImpl.class).in(Singleton.class);
            this.bind(MeasurementRepository.class).to(MeasurementVerticaRepositoryImpl.class).in(Singleton.class);
            this.bind(StatisticRepository.class).to(StatisticVerticaRepositoryImpl.class).in(Singleton.class);
        } else if (this.config.databaseConfiguration.getDatabaseType().trim().toLowerCase().equals("influxdb")) {
            this.bind(AlarmStateHistoryRepository.class).to(AlarmStateHistoryInfluxDbRepositoryImpl.class).in(Singleton.class);
            this.bind(MetricDefinitionRepository.class).to(MetricDefinitionInfluxDbRepositoryImpl.class).in(Singleton.class);
            this.bind(MeasurementRepository.class).to(MeasurementInfluxDbRepositoryImpl.class).in(Singleton.class);
            this.bind(StatisticRepository.class).to(StatisticInfluxDbRepositoryImpl.class).in(Singleton.class);
        } else {
            throw new ProvisionException("Failed to detect supported database. Supported databases are 'vertica' and 'influxdb'. Check your config file.");
        }
        this.bind(NotificationMethodRepository.class).to(NotificationMethodMySqlRepositoryImpl.class).in(Singleton.class);
    }

    @Provides
    InfluxDB provideInfluxDB() {
        InfluxDB influxDB = InfluxDBFactory.connect((String)this.config.influxDB.getUrl(), (String)this.config.influxDB.getUser(), (String)this.config.influxDB.getPassword());
        return influxDB;
    }
}

