/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.influxdb;

import com.google.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import monasca.api.MonApiConfiguration;
import monasca.api.domain.model.measurement.MeasurementRepository;
import monasca.api.domain.model.measurement.Measurements;
import monasca.api.infrastructure.persistence.influxdb.Utils;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Serie;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementInfluxDbRepositoryImpl
implements MeasurementRepository {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementInfluxDbRepositoryImpl.class);
    private final MonApiConfiguration config;
    private final InfluxDB influxDB;
    public static final DateTimeFormatter DATETIME_FORMATTER = ISODateTimeFormat.dateTimeNoMillis().withZoneUTC();

    @Inject
    public MeasurementInfluxDbRepositoryImpl(MonApiConfiguration config, InfluxDB influxDB) {
        this.config = config;
        this.influxDB = influxDB;
    }

    @Override
    public List<Measurements> find(String tenantId, String name, Map<String, String> dimensions, DateTime startTime, @Nullable DateTime endTime, @Nullable String offset) throws Exception {
        String serieNameRegex = Utils.buildSerieNameRegex(tenantId, this.config.region, name, dimensions);
        String timePart = Utils.WhereClauseBuilder.buildTimePart(startTime, endTime);
        String offsetPart = Utils.buildOffsetPart(offset);
        String query = String.format("select value from /%1$s/ where 1 = 1  %2$s  %3$s", serieNameRegex, timePart, offsetPart);
        logger.debug("Query string: {}", (Object)query);
        List result = null;
        try {
            result = this.influxDB.Query(this.config.influxDB.getName(), query, TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            if (e.getMessage().startsWith("Couldn't look up columns")) {
                return new LinkedList<Measurements>();
            }
            logger.error("Failed to get data from InfluxDB", (Throwable)e);
            throw e;
        }
        return this.buildMeasurementList(result);
    }

    private List<Measurements> buildMeasurementList(List<Serie> result) throws Exception {
        LinkedList<Measurements> measurementsList = new LinkedList<Measurements>();
        for (Serie serie : result) {
            Utils.SerieNameDecoder serieNameDecoder;
            try {
                serieNameDecoder = new Utils.SerieNameDecoder(serie.getName());
            }
            catch (Utils.SerieNameDecodeException e) {
                logger.warn("Dropping series name that is not decodable: {}", (Object)serie.getName(), (Object)e);
                continue;
            }
            Measurements measurements = new Measurements();
            measurements.setName(serieNameDecoder.getMetricName());
            measurements.setDimensions(serieNameDecoder.getDimensions());
            LinkedList<Object[]> valObjArryList = new LinkedList<Object[]>();
            for (Map row : serie.getRows()) {
                Object[] objArry = new Object[3];
                objArry[0] = ((Double)row.get(serie.getColumns()[1])).longValue();
                Double timeDouble = (Double)row.get(serie.getColumns()[0]);
                measurements.setId(String.valueOf(timeDouble.longValue()));
                objArry[1] = DATETIME_FORMATTER.print(timeDouble.longValue());
                objArry[2] = (Double)row.get(serie.getColumns()[2]);
                valObjArryList.add(objArry);
            }
            measurements.setMeasurements(valObjArryList);
            measurementsList.add(measurements);
        }
        return measurementsList;
    }
}

