/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.influxdb;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import monasca.api.MonApiConfiguration;
import monasca.api.domain.model.statistic.StatisticRepository;
import monasca.api.domain.model.statistic.Statistics;
import monasca.api.infrastructure.persistence.influxdb.Utils;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Serie;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticInfluxDbRepositoryImpl
implements StatisticRepository {
    private static final Logger logger = LoggerFactory.getLogger(StatisticInfluxDbRepositoryImpl.class);
    private final MonApiConfiguration config;
    private final InfluxDB influxDB;
    public static final DateTimeFormatter DATETIME_FORMATTER = ISODateTimeFormat.dateTimeNoMillis().withZoneUTC();

    @Inject
    public StatisticInfluxDbRepositoryImpl(MonApiConfiguration config, InfluxDB influxDB) {
        this.config = config;
        this.influxDB = influxDB;
    }

    @Override
    public List<Statistics> find(String tenantId, String name, Map<String, String> dimensions, DateTime startTime, @Nullable DateTime endTime, List<String> statistics, int period) throws Exception {
        String serieNameRegex = Utils.buildSerieNameRegex(tenantId, this.config.region, name, dimensions);
        String statsPart = this.buildStatsPart(statistics);
        String timePart = Utils.WhereClauseBuilder.buildTimePart(startTime, endTime);
        String periodPart = this.buildPeriodPart(period);
        String query = String.format("select time %1$s from /%2$s/ where 1=1 %3$s %4$s", statsPart, serieNameRegex, timePart, periodPart);
        logger.debug("Query string: {}", (Object)query);
        List result = null;
        try {
            result = this.influxDB.Query(this.config.influxDB.getName(), query, TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            if (e.getMessage().startsWith("Couldn't look up columns")) {
                return new LinkedList<Statistics>();
            }
            logger.error("Failed to get data from InfluxDB", (Throwable)e);
            throw e;
        }
        return this.buildStatisticsList(statistics, result);
    }

    private List<Statistics> buildStatisticsList(List<String> statistics, List<Serie> result) throws Exception {
        LinkedList<Statistics> statisticsList = new LinkedList<Statistics>();
        for (Serie serie : result) {
            Utils.SerieNameDecoder serieNameDecoder;
            try {
                serieNameDecoder = new Utils.SerieNameDecoder(serie.getName());
            }
            catch (Utils.SerieNameDecodeException e) {
                logger.warn("Dropping series name that is not decodable: {}", (Object)serie.getName(), (Object)e);
                continue;
            }
            Statistics statistic = new Statistics();
            statistic.setName(serieNameDecoder.getMetricName());
            LinkedList<String> colNamesList = new LinkedList<String>(statistics);
            colNamesList.add(0, "timestamp");
            statistic.setColumns(colNamesList);
            statistic.setDimensions(serieNameDecoder.getDimensions());
            LinkedList<List<Object>> valObjArryArry = new LinkedList<List<Object>>();
            statistic.setStatistics(valObjArryArry);
            for (Map row : serie.getRows()) {
                ArrayList<String> valObjArry = new ArrayList<String>();
                Double timeDouble = (Double)row.get(serie.getColumns()[0]);
                valObjArry.add(DATETIME_FORMATTER.print(timeDouble.longValue()));
                for (int j = 1; j < statistics.size() + 1; ++j) {
                    valObjArry.add((String)row.get(serie.getColumns()[j]));
                }
                valObjArryArry.add(valObjArry);
            }
            statisticsList.add(statistic);
        }
        return statisticsList;
    }

    private String buildPeriodPart(int period) {
        String s = "";
        if (period >= 1) {
            s = s + String.format("group by time(%1$ds)", period);
        }
        return s;
    }

    private String buildStatsPart(List<String> statistics) {
        String s = "";
        for (String statistic : statistics) {
            s = s + ",";
            if (statistic.trim().toLowerCase().equals("avg")) {
                s = s + " mean(value)";
                continue;
            }
            s = s + " " + statistic + "(value)";
        }
        return s;
    }
}

