/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.mysql;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.exception.EntityNotFoundException;
import monasca.api.domain.model.alarmdefinition.AlarmDefinition;
import monasca.api.domain.model.alarmdefinition.AlarmDefinitionRepository;
import monasca.api.infrastructure.persistence.DimensionQueries;
import monasca.api.infrastructure.persistence.SubAlarmQueries;
import monasca.common.model.alarm.AggregateFunction;
import monasca.common.model.alarm.AlarmOperator;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.metric.MetricDefinition;
import monasca.common.persistence.BeanMapper;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class AlarmDefinitionMySqlRepositoryImpl
implements AlarmDefinitionRepository {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final String SUB_ALARM_SQL = "select sa.*, sad.dimensions from sub_alarm_definition as sa left join (select sub_alarm_definition_id, group_concat(dimension_name, '=', value) as dimensions from sub_alarm_definition_dimension group by sub_alarm_definition_id ) as sad on sad.sub_alarm_definition_id = sa.id where sa.alarm_definition_id = :alarmDefId";
    private final DBI db;

    @Inject
    public AlarmDefinitionMySqlRepositoryImpl(@Named(value="mysql") DBI db) {
        this.db = db;
    }

    @Override
    public AlarmDefinition create(String tenantId, String id, String name, String description, String severity, String expression, Map<String, AlarmSubExpression> subExpressions, List<String> matchBy, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        try (Handle h = this.db.open();){
            h.begin();
            h.insert("insert into alarm_definition (id, tenant_id, name, description, severity, expression, match_by, actions_enabled, created_at, updated_at, deleted_at) values (?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW(), NULL)", new Object[]{id, tenantId, name, description, severity, expression, matchBy == null || Iterables.isEmpty(matchBy) ? null : COMMA_JOINER.join(matchBy), true});
            this.createSubExpressions(h, id, subExpressions);
            this.persistActions(h, id, AlarmState.ALARM, alarmActions);
            this.persistActions(h, id, AlarmState.OK, okActions);
            this.persistActions(h, id, AlarmState.UNDETERMINED, undeterminedActions);
            h.commit();
            AlarmDefinition alarmDefinition = new AlarmDefinition(id, name, description, severity, expression, matchBy, true, alarmActions, okActions == null ? Collections.emptyList() : okActions, undeterminedActions == null ? Collections.emptyList() : undeterminedActions);
            return alarmDefinition;
        }
    }

    @Override
    public void deleteById(String tenantId, String alarmDefId) {
        try (Handle h = this.db.open();){
            if (h.update("update alarm_definition set deleted_at = NOW() where tenant_id = ? and id = ? and deleted_at is NULL", new Object[]{tenantId, alarmDefId}) == 0) {
                throw new EntityNotFoundException("No alarm definition exists for %s", alarmDefId);
            }
            h.execute("delete from alarm where alarm_definition_id = :id", new Object[]{alarmDefId});
        }
    }

    @Override
    public boolean exists(String tenantId, String name) {
        try (Handle h = this.db.open();){
            boolean bl = (Boolean)((Query)((Query)h.createQuery("select exists(select 1 from alarm_definition where tenant_id = :tenantId and name = :name and deleted_at is NULL)").bind("tenantId", tenantId)).bind("name", name)).mapTo(Boolean.TYPE).first();
            return bl;
        }
    }

    @Override
    public List<AlarmDefinition> find(String tenantId, String name, Map<String, String> dimensions, String offset) {
        try (Handle h = this.db.open();){
            String query = "select distinct ad.id, ad.description, ad.tenant_id, ad.severity, ad.expression, ad.match_by, ad.name, ad.actions_enabled, ad.created_at, ad.updated_at, ad.deleted_at from alarm_definition ad join sub_alarm_definition sub on ad.id = sub.alarm_definition_id left outer join sub_alarm_definition_dimension dim on sub.id = dim.sub_alarm_definition_id%s where tenant_id = :tenantId and deleted_at is NULL %s order by %s ad.created_at %s";
            StringBuilder sbWhere = new StringBuilder();
            if (name != null) {
                sbWhere.append(" and ad.name = :name");
            }
            if (offset != null) {
                sbWhere.append(" and ad.id > :offset");
            }
            String orderBy = offset != null ? "ad.id," : "";
            String limit = offset != null ? " limit :limit" : "";
            String sql = String.format(query, SubAlarmQueries.buildJoinClauseFor(dimensions), sbWhere, orderBy, limit);
            Query q = (Query)h.createQuery(sql).bind("tenantId", tenantId);
            if (name != null) {
                q.bind("name", name);
            }
            if (offset != null) {
                q.bind("offset", offset);
                q.bind("limit", 50);
            }
            q = q.map((ResultSetMapper)new BeanMapper(AlarmDefinition.class));
            DimensionQueries.bindDimensionsToQuery(q, dimensions);
            List alarms = q.list();
            for (AlarmDefinition alarm : alarms) {
                this.hydrateRelationships(h, alarm);
            }
            List list = alarms;
            return list;
        }
    }

    @Override
    public AlarmDefinition findById(String tenantId, String alarmDefId) {
        try (Handle h = this.db.open();){
            AlarmDefinition alarm = (AlarmDefinition)((Query)((Query)h.createQuery("select * from alarm_definition where tenant_id = :tenantId and id = :id and deleted_at is NULL").bind("tenantId", tenantId)).bind("id", alarmDefId)).map((ResultSetMapper)new BeanMapper(AlarmDefinition.class)).first();
            if (alarm == null) {
                throw new EntityNotFoundException("No alarm definition exists for %s", alarmDefId);
            }
            this.hydrateRelationships(h, alarm);
            AlarmDefinition alarmDefinition = alarm;
            return alarmDefinition;
        }
    }

    @Override
    public Map<String, MetricDefinition> findSubAlarmMetricDefinitions(String alarmDefId) {
        try (Handle h = this.db.open();){
            List rows = ((Query)h.createQuery(SUB_ALARM_SQL).bind("alarmDefId", alarmDefId)).list();
            HashMap<String, MetricDefinition> subAlarmMetricDefs = new HashMap<String, MetricDefinition>();
            for (Map row : rows) {
                String id = (String)row.get("id");
                String metricName = (String)row.get("metric_name");
                Map<String, String> dimensions = DimensionQueries.dimensionsFor((String)row.get("dimensions"));
                subAlarmMetricDefs.put(id, new MetricDefinition(metricName, dimensions));
            }
            HashMap<String, MetricDefinition> hashMap = subAlarmMetricDefs;
            return hashMap;
        }
    }

    @Override
    public Map<String, AlarmSubExpression> findSubExpressions(String alarmDefId) {
        try (Handle h = this.db.open();){
            List rows = ((Query)h.createQuery(SUB_ALARM_SQL).bind("alarmDefId", alarmDefId)).list();
            HashMap<String, AlarmSubExpression> subExpressions = new HashMap<String, AlarmSubExpression>();
            for (Map row : rows) {
                String id = (String)row.get("id");
                AggregateFunction function = AggregateFunction.fromJson((String)((String)row.get("function")));
                String metricName = (String)row.get("metric_name");
                AlarmOperator operator = AlarmOperator.fromJson((String)((String)row.get("operator")));
                Double threshold = (Double)row.get("threshold");
                Integer period = (Integer)row.get("period");
                Integer periods = (Integer)row.get("periods");
                Map<String, String> dimensions = DimensionQueries.dimensionsFor((String)row.get("dimensions"));
                subExpressions.put(id, new AlarmSubExpression(function, new MetricDefinition(metricName, dimensions), operator, threshold.doubleValue(), period.intValue(), periods.intValue()));
            }
            HashMap<String, AlarmSubExpression> hashMap = subExpressions;
            return hashMap;
        }
    }

    @Override
    public void update(String tenantId, String id, boolean patch, String name, String description, String expression, List<String> matchBy, String severity, boolean actionsEnabled, Collection<String> oldSubAlarmIds, Map<String, AlarmSubExpression> changedSubAlarms, Map<String, AlarmSubExpression> newSubAlarms, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        try (Handle h = this.db.open();){
            h.begin();
            h.insert("update alarm_definition set name = ?, description = ?, expression = ?, match_by = ?, severity = ?, actions_enabled = ?, updated_at = NOW() where tenant_id = ? and id = ?", new Object[]{name, description, expression, matchBy == null || Iterables.isEmpty(matchBy) ? null : COMMA_JOINER.join(matchBy), severity, actionsEnabled, tenantId, id});
            if (oldSubAlarmIds != null) {
                for (String string : oldSubAlarmIds) {
                    h.execute("delete from sub_alarm_definition where id = ?", new Object[]{string});
                }
            }
            if (changedSubAlarms != null) {
                for (Map.Entry entry : changedSubAlarms.entrySet()) {
                    AlarmSubExpression sa = (AlarmSubExpression)entry.getValue();
                    h.execute("update sub_alarm_definition set operator = ?, threshold = ?, updated_at = NOW() where id = ?", new Object[]{sa.getOperator().name(), sa.getThreshold(), entry.getKey()});
                }
            }
            this.createSubExpressions(h, id, newSubAlarms);
            if (patch) {
                this.deleteActions(h, id, AlarmState.ALARM, alarmActions);
                this.deleteActions(h, id, AlarmState.OK, okActions);
                this.deleteActions(h, id, AlarmState.UNDETERMINED, undeterminedActions);
            } else {
                h.execute("delete from alarm_action where alarm_definition_id = ?", new Object[]{id});
            }
            this.persistActions(h, id, AlarmState.ALARM, alarmActions);
            this.persistActions(h, id, AlarmState.OK, okActions);
            this.persistActions(h, id, AlarmState.UNDETERMINED, undeterminedActions);
            h.commit();
        }
    }

    private void deleteActions(Handle handle, String id, AlarmState alarmState, List<String> actions) {
        if (actions != null) {
            handle.execute("delete from alarm_action where alarm_definition_id = ? and alarm_state = ?", new Object[]{id, alarmState.name()});
        }
    }

    private List<String> findActionsById(Handle handle, String alarmDefId, AlarmState state) {
        return ((Query)((Query)handle.createQuery("select action_id from alarm_action where alarm_definition_id = :alarmDefId and alarm_state = :alarmState").bind("alarmDefId", alarmDefId)).bind("alarmState", state.name())).map((ResultSetMapper)StringMapper.FIRST).list();
    }

    private void persistActions(Handle handle, String id, AlarmState alarmState, List<String> actions) {
        if (actions != null) {
            for (String action : actions) {
                handle.insert("insert into alarm_action values (?, ?, ?)", new Object[]{id, alarmState.name(), action});
            }
        }
    }

    private void hydrateRelationships(Handle handle, AlarmDefinition alarm) {
        alarm.setAlarmActions(this.findActionsById(handle, alarm.getId(), AlarmState.ALARM));
        alarm.setOkActions(this.findActionsById(handle, alarm.getId(), AlarmState.OK));
        alarm.setUndeterminedActions(this.findActionsById(handle, alarm.getId(), AlarmState.UNDETERMINED));
    }

    private void createSubExpressions(Handle handle, String id, Map<String, AlarmSubExpression> alarmSubExpressions) {
        if (alarmSubExpressions != null) {
            for (Map.Entry<String, AlarmSubExpression> subEntry : alarmSubExpressions.entrySet()) {
                String subAlarmId = subEntry.getKey();
                AlarmSubExpression subExpr = subEntry.getValue();
                MetricDefinition metricDef = subExpr.getMetricDefinition();
                handle.insert("insert into sub_alarm_definition (id, alarm_definition_id, function, metric_name, operator, threshold, period, periods, created_at, updated_at) values (?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())", new Object[]{subAlarmId, id, subExpr.getFunction().name(), metricDef.name, subExpr.getOperator().name(), subExpr.getThreshold(), subExpr.getPeriod(), subExpr.getPeriods()});
                if (metricDef.dimensions == null || metricDef.dimensions.isEmpty()) continue;
                for (Map.Entry dimEntry : metricDef.dimensions.entrySet()) {
                    handle.insert("insert into sub_alarm_definition_dimension values (?, ?, ?)", new Object[]{subAlarmId, dimEntry.getKey(), dimEntry.getValue()});
                }
            }
        }
    }
}

