/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.mysql;

import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.exception.EntityExistsException;
import monasca.api.domain.exception.EntityNotFoundException;
import monasca.api.domain.model.notificationmethod.NotificationMethod;
import monasca.api.domain.model.notificationmethod.NotificationMethodRepository;
import monasca.api.domain.model.notificationmethod.NotificationMethodType;
import monasca.common.persistence.BeanMapper;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationMethodMySqlRepositoryImpl
implements NotificationMethodRepository {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationMethodMySqlRepositoryImpl.class);
    private final DBI db;

    @Inject
    public NotificationMethodMySqlRepositoryImpl(@Named(value="mysql") DBI db) {
        this.db = db;
    }

    @Override
    public NotificationMethod create(String tenantId, String name, NotificationMethodType type, String address) {
        if (this.exists(tenantId, name, type, address)) {
            throw new EntityExistsException("Notification method %s \"%s\" %s \"%s\" already exists.", new Object[]{tenantId, name, type, address});
        }
        try (Handle h = this.db.open();){
            String id = UUID.randomUUID().toString();
            h.insert("insert into notification_method (id, tenant_id, name, type, address, created_at, updated_at) values (?, ?, ?, ?, ?, NOW(), NOW())", new Object[]{id, tenantId, name, type.toString(), address});
            LOG.debug("Creating notification method {} for {}", (Object)name, (Object)tenantId);
            NotificationMethod notificationMethod = new NotificationMethod(id, name, type, address);
            return notificationMethod;
        }
    }

    @Override
    public void deleteById(String tenantId, String notificationMethodId) {
        try (Handle h = this.db.open();){
            if (h.update("delete from notification_method where tenant_id = ? and id = ?", new Object[]{tenantId, notificationMethodId}) == 0) {
                throw new EntityNotFoundException("No notification method exists for %s", notificationMethodId);
            }
        }
    }

    @Override
    public boolean exists(String tenantId, String notificationMethodId) {
        try (Handle h = this.db.open();){
            boolean bl = (Boolean)((Query)((Query)h.createQuery("select exists(select 1 from notification_method where tenant_id = :tenantId and id = :notificationMethodId)").bind("tenantId", tenantId)).bind("notificationMethodId", notificationMethodId)).mapTo(Boolean.TYPE).first();
            return bl;
        }
    }

    public boolean exists(String tenantId, String name, NotificationMethodType type, String address) {
        try (Handle h = this.db.open();){
            boolean bl = (Boolean)((Query)((Query)((Query)((Query)h.createQuery("select exists(select 1 from notification_method where tenant_id = :tenantId and name = :name and type = :type and address = :address)").bind("tenantId", tenantId)).bind("name", name)).bind("type", type.toString())).bind("address", address)).mapTo(Boolean.TYPE).first();
            return bl;
        }
    }

    @Override
    public List<NotificationMethod> find(String tenantId, String offset) {
        try (Handle h = this.db.open();){
            if (offset != null) {
                List list = ((Query)((Query)((Query)h.createQuery("select * from notification_method where tenant_id = :tenantId and id > :offset order by id asc limit :limit").bind("tenantId", tenantId)).bind("offset", offset)).bind("limit", 50)).map((ResultSetMapper)new BeanMapper(NotificationMethod.class)).list();
                return list;
            }
            List list = ((Query)h.createQuery("select * from notification_method where tenant_id = :tenantId").bind("tenantId", tenantId)).map((ResultSetMapper)new BeanMapper(NotificationMethod.class)).list();
            return list;
        }
    }

    @Override
    public NotificationMethod findById(String tenantId, String notificationMethodId) {
        try (Handle h = this.db.open();){
            NotificationMethod notificationMethod = (NotificationMethod)((Query)((Query)h.createQuery("select * from notification_method where tenant_id = :tenantId and id = :id").bind("tenantId", tenantId)).bind("id", notificationMethodId)).map((ResultSetMapper)new BeanMapper(NotificationMethod.class)).first();
            if (notificationMethod == null) {
                throw new EntityNotFoundException("No notification method exists for %s", notificationMethodId);
            }
            NotificationMethod notificationMethod2 = notificationMethod;
            return notificationMethod2;
        }
    }

    @Override
    public NotificationMethod update(String tenantId, String notificationMethodId, String name, NotificationMethodType type, String address) {
        try (Handle h = this.db.open();){
            if (h.update("update notification_method set name = ?, type = ?, address = ? where tenant_id = ? and id = ?", new Object[]{name, type.name(), address, tenantId, notificationMethodId}) == 0) {
                throw new EntityNotFoundException("No notification method exists for %s", notificationMethodId);
            }
            NotificationMethod notificationMethod = new NotificationMethod(notificationMethodId, name, type, address);
            return notificationMethod;
        }
    }
}

