/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import monasca.api.app.AlarmDefinitionService;
import monasca.api.app.command.CreateAlarmDefinitionCommand;
import monasca.api.app.command.UpdateAlarmDefinitionCommand;
import monasca.api.app.validation.AlarmValidation;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.alarmdefinition.AlarmDefinition;
import monasca.api.domain.model.alarmdefinition.AlarmDefinitionRepository;
import monasca.api.resource.Links;
import monasca.api.resource.annotation.PATCH;
import monasca.common.model.alarm.AlarmExpression;
import org.hibernate.validator.constraints.NotEmpty;

@Path(value="/v2.0/alarm-definitions")
public class AlarmDefinitionResource {
    private final AlarmDefinitionService service;
    private final AlarmDefinitionRepository repo;
    public static final String ALARM_DEFINITIONS = "alarm-definitions";
    public static final String ALARM_DEFINITIONS_PATH = "/v2.0/alarm-definitions";

    @Inject
    public AlarmDefinitionResource(AlarmDefinitionService service, AlarmDefinitionRepository repo) {
        this.service = service;
        this.repo = repo;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @Valid CreateAlarmDefinitionCommand command) {
        command.validate();
        AlarmExpression alarmExpression = AlarmValidation.validateNormalizeAndGet(command.expression);
        AlarmDefinition alarm = Links.hydrate(this.service.create(tenantId, command.name, command.description, command.severity, command.expression, alarmExpression, command.matchBy, command.alarmActions, command.okActions, command.undeterminedActions), uriInfo, false, new String[0]);
        return Response.created((URI)URI.create(alarm.getId())).entity((Object)alarm).build();
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object list(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="name") String name, @QueryParam(value="dimensions") String dimensionsStr, @QueryParam(value="offset") String offset) {
        Map<String, String> dimensions = Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseAndValidateDimensions(dimensionsStr);
        return Links.paginate(offset, Links.hydrate(this.repo.find(tenantId, name, dimensions, offset), uriInfo, new String[0]), uriInfo);
    }

    @GET
    @Timed
    @Path(value="/{alarm_definition_id}")
    @Produces(value={"application/json"})
    public AlarmDefinition get(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_definition_id") String alarmDefinitionId) {
        return Links.hydrate(this.repo.findById(tenantId, alarmDefinitionId), uriInfo, true, new String[0]);
    }

    @PUT
    @Timed
    @Path(value="/{alarm_definition_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public AlarmDefinition update(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_definition_id") String alarmDefinitionId, @Valid UpdateAlarmDefinitionCommand command) {
        command.validate();
        AlarmExpression alarmExpression = AlarmValidation.validateNormalizeAndGet(command.expression);
        return Links.hydrate(this.service.update(tenantId, alarmDefinitionId, alarmExpression, command), uriInfo, true, new String[0]);
    }

    @PATCH
    @Timed
    @Path(value="/{alarm_definition_id}")
    @Consumes(value={"application/json-patch+json", "application/json"})
    @Produces(value={"application/json"})
    public AlarmDefinition patch(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_definition_id") String alarmDefinitionId, @NotEmpty Map<String, Object> fields) throws JsonMappingException {
        String name = (String)fields.get("name");
        String description = (String)fields.get("description");
        String severity = (String)fields.get("severity");
        String expression = (String)fields.get("expression");
        List matchBy = (List)fields.get("match_by");
        Boolean enabled = (Boolean)fields.get("actions_enabled");
        List alarmActions = (List)fields.get("alarm_actions");
        List okActions = (List)fields.get("ok_actions");
        List undeterminedActions = (List)fields.get("undetermined_actions");
        AlarmValidation.validate(name, description, severity, alarmActions, okActions, undeterminedActions);
        AlarmExpression alarmExpression = expression == null ? null : AlarmValidation.validateNormalizeAndGet(expression);
        return Links.hydrate(this.service.patch(tenantId, alarmDefinitionId, name, description, severity, expression, alarmExpression, matchBy, enabled, alarmActions, okActions, undeterminedActions), uriInfo, true, new String[0]);
    }

    @DELETE
    @Timed
    @Path(value="/{alarm_definition_id}")
    public void delete(@HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_definition_id") String alarmDefinitionId) {
        this.service.delete(tenantId, alarmDefinitionId);
    }
}

