/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import java.net.URI;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import monasca.api.app.command.CreateNotificationMethodCommand;
import monasca.api.domain.model.notificationmethod.NotificationMethod;
import monasca.api.domain.model.notificationmethod.NotificationMethodRepository;
import monasca.api.resource.Links;

@Path(value="/v2.0/notification-methods")
public class NotificationMethodResource {
    private final NotificationMethodRepository repo;

    @Inject
    public NotificationMethodResource(NotificationMethodRepository repo) {
        this.repo = repo;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @Valid CreateNotificationMethodCommand command) {
        command.validate();
        NotificationMethod notificationMethod = Links.hydrate(this.repo.create(tenantId, command.name, command.type, command.address), uriInfo, false, new String[0]);
        return Response.created((URI)URI.create(notificationMethod.getId())).entity((Object)notificationMethod).build();
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object list(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="offset") String offset) {
        return Links.paginate(offset, Links.hydrate(this.repo.find(tenantId, offset), uriInfo, new String[0]), uriInfo);
    }

    @GET
    @Timed
    @Path(value="/{notification_method_id}")
    @Produces(value={"application/json"})
    public NotificationMethod get(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="notification_method_id") String notificationMethodId) {
        return Links.hydrate(this.repo.findById(tenantId, notificationMethodId), uriInfo, true, new String[0]);
    }

    @PUT
    @Timed
    @Path(value="/{notification_method_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public NotificationMethod update(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="notification_method_id") String notificationMethodId, @Valid CreateNotificationMethodCommand command) {
        command.validate();
        return Links.hydrate(this.repo.update(tenantId, notificationMethodId, command.name, command.type, command.address), uriInfo, true, new String[0]);
    }

    @DELETE
    @Timed
    @Path(value="/{notification_method_id}")
    public void delete(@HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="notification_method_id") String notificationMethodId) {
        this.repo.deleteById(tenantId, notificationMethodId);
    }
}

