/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.statistic.StatisticRepository;
import monasca.api.domain.model.statistic.Statistics;
import org.joda.time.DateTime;

@Path(value="/v2.0/metrics/statistics")
public class StatisticResource {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final StatisticRepository repo;

    @Inject
    public StatisticResource(StatisticRepository repo) {
        this.repo = repo;
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public List<Statistics> get(@HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="name") String name, @QueryParam(value="dimensions") String dimensionsStr, @QueryParam(value="start_time") String startTimeStr, @QueryParam(value="end_time") String endTimeStr, @QueryParam(value="statistics") String statisticsStr, @DefaultValue(value="300") @QueryParam(value="period") String periodStr) throws Exception {
        DateTime startTime = Validation.parseAndValidateDate(startTimeStr, "start_time", true);
        DateTime endTime = Validation.parseAndValidateDate(endTimeStr, "end_time", false);
        Validation.validateTimes(startTime, endTime);
        Validation.validateNotNullOrEmpty(statisticsStr, "statistics");
        int period = Validation.parseAndValidateNumber(periodStr, "period");
        List<String> statistics = Validation.parseValidateAndNormalizeStatistics(COMMA_SPLITTER.split((CharSequence)statisticsStr));
        Map<String, String> dimensions = Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseAndValidateNameAndDimensions(name, dimensionsStr);
        return this.repo.find(tenantId, name, dimensions, startTime, endTime, statistics, period);
    }
}

