/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.domain.model.version.Version;
import monasca.api.domain.model.version.VersionRepository;
import monasca.api.resource.Links;

@Path(value="/")
@Produces(value={"application/json"})
public class VersionResource {
    private final VersionRepository repository;

    @Inject
    public VersionResource(VersionRepository repository) {
        this.repository = repository;
    }

    @GET
    @Timed
    public List<Version> list(@Context UriInfo uriInfo) {
        return Links.hydrate(this.repository.find(), uriInfo, new String[0]);
    }

    @GET
    @Timed
    @Path(value="{version_id}")
    public Version get(@Context UriInfo uriInfo, @PathParam(value="version_id") String versionId) {
        return Links.hydrate(this.repository.findById(versionId), uriInfo, true, new String[0]);
    }
}

