/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.app.validation;

import java.util.List;
import monasca.api.resource.exception.Exceptions;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;

public class NotificationMethodValidation {
    private static final String[] SCHEMES = new String[]{"http", "https"};
    private static final RegexValidator TEST_TLD_VALIDATOR = new RegexValidator(".+\\.test(:[0-9]+)?$");
    private static final UrlValidator URL_VALIDATOR = new UrlValidator(SCHEMES, TEST_TLD_VALIDATOR, 10L);

    public static void validate(String type, String address, int period, List<Integer> validPeriods) {
        if (type.equals("EMAIL") && !EmailValidator.getInstance((boolean)true).isValid(address)) {
            throw Exceptions.unprocessableEntity("Address %s is not of correct format", address);
        }
        if (type.equals("WEBHOOK")) {
            if (!URL_VALIDATOR.isValid(address)) {
                throw Exceptions.unprocessableEntity("Address %s is not of correct format", address);
            }
            if (period != 0 && !validPeriods.contains(period)) {
                throw Exceptions.unprocessableEntity("%d is not a valid period", period);
            }
        }
        if (period != 0 && !type.equals("WEBHOOK")) {
            throw Exceptions.unprocessableEntity("Period can not be non zero for %s", type);
        }
    }
}

