/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.domain.model.alarmdefinition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import monasca.api.domain.model.common.Link;
import monasca.api.domain.model.common.Linked;
import monasca.common.model.alarm.AlarmExpression;
import monasca.common.model.domain.common.AbstractEntity;

@XmlRootElement(name="Alarm definition")
public class AlarmDefinition
extends AbstractEntity
implements Linked {
    private List<Link> links;
    private String name;
    private String description = "";
    private String expression;
    private boolean deterministic;
    private Object expressionData;
    private List<String> matchBy;
    private String severity;
    private boolean actionsEnabled;
    private List<String> alarmActions;
    private List<String> okActions;
    private List<String> undeterminedActions;

    public AlarmDefinition() {
    }

    public AlarmDefinition(String id, String name, String description, String severity, String expression, List<String> matchBy, boolean actionsEnabled, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        this.id = id;
        this.name = name;
        this.setDescription(description);
        this.setSeverity(severity);
        this.setExpression(expression);
        this.setMatchBy(matchBy);
        this.setActionsEnabled(actionsEnabled);
        this.setAlarmActions(alarmActions);
        this.setOkActions(okActions);
        this.setUndeterminedActions(undeterminedActions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AlarmDefinition)) {
            return false;
        }
        AlarmDefinition other = (AlarmDefinition)obj;
        if (this.actionsEnabled != other.actionsEnabled) {
            return false;
        }
        if (this.alarmActions == null ? other.alarmActions != null : !this.alarmActions.equals(other.alarmActions)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.expressionData == null ? other.expressionData != null : !this.expressionData.equals(other.expressionData)) {
            return false;
        }
        if (this.deterministic != other.deterministic) {
            return false;
        }
        if (this.links == null ? other.links != null : !this.links.equals(other.links)) {
            return false;
        }
        if (this.matchBy == null ? other.matchBy != null : !this.matchBy.equals(other.matchBy)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.okActions == null ? other.okActions != null : !this.okActions.equals(other.okActions)) {
            return false;
        }
        if (this.severity == null ? other.severity != null : !this.severity.equals(other.severity)) {
            return false;
        }
        return !(this.undeterminedActions == null ? other.undeterminedActions != null : !this.undeterminedActions.equals(other.undeterminedActions));
    }

    public List<String> getAlarmActions() {
        return this.alarmActions;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExpression() {
        return this.expression;
    }

    public Object getExpressionData() {
        return this.expressionData;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public List<Link> getLinks() {
        return this.links;
    }

    public List<String> getMatchBy() {
        return this.matchBy;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getOkActions() {
        return this.okActions;
    }

    public String getSeverity() {
        return this.severity;
    }

    public List<String> getUndeterminedActions() {
        return this.undeterminedActions;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.actionsEnabled ? 1231 : 1237);
        result = 31 * result + (this.alarmActions == null ? 0 : this.alarmActions.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.expressionData == null ? 0 : this.expressionData.hashCode());
        result = 31 * result + Boolean.valueOf(this.deterministic).hashCode();
        result = 31 * result + (this.links == null ? 0 : this.links.hashCode());
        result = 31 * result + (this.matchBy == null ? 0 : this.matchBy.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.okActions == null ? 0 : this.okActions.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.undeterminedActions == null ? 0 : this.undeterminedActions.hashCode());
        return result;
    }

    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    public void setActionsEnabled(boolean actionsEnabled) {
        this.actionsEnabled = actionsEnabled;
    }

    public void setAlarmActions(List<String> alarmActions) {
        this.alarmActions = alarmActions;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public void setExpression(String expression) {
        this.expression = expression;
        AlarmExpression alarmExpression = AlarmExpression.of((String)expression);
        this.setExpressionData(alarmExpression.getExpressionTree());
        this.deterministic = alarmExpression.isDeterministic();
    }

    @JsonIgnore
    public void setExpressionData(Object expressionData) {
        this.expressionData = expressionData;
    }

    @XmlElement(name="id")
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public void setMatchBy(List<String> matchBy) {
        this.matchBy = matchBy == null ? Collections.emptyList() : matchBy;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOkActions(List<String> okActions) {
        this.okActions = okActions;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public void setUndeterminedActions(List<String> undeterminedActions) {
        this.undeterminedActions = undeterminedActions;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public String toString() {
        return String.format("AlarmDefinition [name=%s]", this.name);
    }
}

