/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.influxdb;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.google.inject.Inject;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import monasca.api.domain.model.alarmstatehistory.AlarmStateHistory;
import monasca.api.domain.model.alarmstatehistory.AlarmStateHistoryRepo;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.infrastructure.persistence.Utils;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9RepoReader;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9Utils;
import monasca.api.infrastructure.persistence.influxdb.Serie;
import monasca.api.infrastructure.persistence.influxdb.Series;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmTransitionSubAlarm;
import monasca.common.model.metric.MetricDefinition;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxV9AlarmStateHistoryRepo
implements AlarmStateHistoryRepo {
    private static final Logger logger = LoggerFactory.getLogger(InfluxV9AlarmStateHistoryRepo.class);
    private final Utils utils;
    private final InfluxV9RepoReader influxV9RepoReader;
    private final InfluxV9Utils influxV9Utils;
    private final PersistUtils persistUtils;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final TypeReference<List<MetricDefinition>> METRICS_TYPE;
    private static final TypeReference<List<AlarmTransitionSubAlarm>> SUB_ALARMS_TYPE;

    @Inject
    public InfluxV9AlarmStateHistoryRepo(Utils utils, InfluxV9RepoReader influxV9RepoReader, InfluxV9Utils influxV9Utils, PersistUtils persistUtils) {
        this.utils = utils;
        this.influxV9RepoReader = influxV9RepoReader;
        this.influxV9Utils = influxV9Utils;
        this.persistUtils = persistUtils;
    }

    @Override
    public List<AlarmStateHistory> findById(String tenantId, String alarmId, String offset, int limit) throws Exception {
        String q = String.format("select alarm_id, metrics, old_state, new_state, reason, reason_data, sub_alarms from alarm_state_history where %1$s %2$s %3$s %4$s", this.influxV9Utils.publicTenantIdPart(tenantId), this.influxV9Utils.alarmIdPart(alarmId), this.influxV9Utils.timeOffsetPart(offset), this.influxV9Utils.limitPart(limit));
        logger.debug("Alarm state history query: {}", (Object)q);
        String r = this.influxV9RepoReader.read(q);
        Series series = (Series)objectMapper.readValue(r, Series.class);
        List<AlarmStateHistory> alarmStateHistoryList = this.alarmStateHistoryList(series);
        logger.debug("Found {} alarm state transitions matching query", (Object)alarmStateHistoryList.size());
        return alarmStateHistoryList;
    }

    @Override
    public List<AlarmStateHistory> find(String tenantId, Map<String, String> dimensions, DateTime startTime, @Nullable DateTime endTime, @Nullable String offset, int limit) throws Exception {
        List<String> alarmIdList = this.utils.findAlarmIds(tenantId, dimensions);
        if (alarmIdList == null || alarmIdList.isEmpty()) {
            return new ArrayList<AlarmStateHistory>();
        }
        String q = String.format("select alarm_id, metrics, old_state, new_state, reason, reason_data, sub_alarms from alarm_state_history where %1$s %2$s %3$s %4$s %5$s", this.influxV9Utils.publicTenantIdPart(tenantId), this.influxV9Utils.startTimeEndTimePart(startTime, endTime), this.influxV9Utils.alarmIdsPart(alarmIdList), this.influxV9Utils.timeOffsetPart(offset), this.influxV9Utils.limitPart(limit));
        logger.debug("Alarm state history list query: {}", (Object)q);
        String r = this.influxV9RepoReader.read(q);
        Series series = (Series)objectMapper.readValue(r, Series.class);
        List<AlarmStateHistory> alarmStateHistoryList = this.alarmStateHistoryList(series);
        logger.debug("Found {} alarm state transitions matching query", (Object)alarmStateHistoryList.size());
        return alarmStateHistoryList;
    }

    private List<AlarmStateHistory> alarmStateHistoryList(Series series) {
        LinkedList<AlarmStateHistory> alarmStateHistoryList = new LinkedList<AlarmStateHistory>();
        if (!series.isEmpty()) {
            for (Serie serie : series.getSeries()) {
                for (String[] values : serie.getValues()) {
                    List subAlarmList;
                    List metricDefinitionList;
                    Date date;
                    AlarmStateHistory alarmStateHistory = new AlarmStateHistory();
                    try {
                        date = this.persistUtils.parseTimestamp(values[0]);
                    }
                    catch (ParseException e) {
                        logger.error("Failed to parse time", (Throwable)e);
                        continue;
                    }
                    DateTime dateTime = new DateTime(date.getTime(), DateTimeZone.UTC);
                    alarmStateHistory.setTimestamp(dateTime);
                    alarmStateHistory.setAlarmId(values[1]);
                    try {
                        metricDefinitionList = (List)objectMapper.readValue(values[2], METRICS_TYPE);
                    }
                    catch (IOException e) {
                        logger.error("Failed to parse metrics", (Throwable)e);
                        continue;
                    }
                    alarmStateHistory.setMetrics(metricDefinitionList);
                    alarmStateHistory.setOldState(AlarmState.valueOf((String)values[3]));
                    alarmStateHistory.setNewState(AlarmState.valueOf((String)values[4]));
                    alarmStateHistory.setReason(values[5]);
                    alarmStateHistory.setReasonData(values[6]);
                    try {
                        subAlarmList = (List)objectMapper.readValue(values[7], SUB_ALARMS_TYPE);
                    }
                    catch (IOException e) {
                        logger.error("Failed to parse sub-alarms", (Throwable)e);
                        continue;
                    }
                    alarmStateHistory.setSubAlarms(subAlarmList);
                    alarmStateHistoryList.add(alarmStateHistory);
                }
            }
        }
        return alarmStateHistoryList;
    }

    static {
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        METRICS_TYPE = new TypeReference<List<MetricDefinition>>(){};
        SUB_ALARMS_TYPE = new TypeReference<List<AlarmTransitionSubAlarm>>(){};
    }
}

