/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.influxdb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import monasca.api.ApiConfig;
import monasca.api.domain.model.dimension.DimensionName;
import monasca.api.domain.model.dimension.DimensionRepo;
import monasca.api.domain.model.dimension.DimensionValue;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9RepoReader;
import monasca.api.infrastructure.persistence.influxdb.InfluxV9Utils;
import monasca.api.infrastructure.persistence.influxdb.Serie;
import monasca.api.infrastructure.persistence.influxdb.Series;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxV9DimensionRepo
implements DimensionRepo {
    private static final Logger logger = LoggerFactory.getLogger(InfluxV9DimensionRepo.class);
    private final ApiConfig config;
    private final InfluxV9RepoReader influxV9RepoReader;
    private final InfluxV9Utils influxV9Utils;
    private final String region;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public InfluxV9DimensionRepo(ApiConfig config, InfluxV9RepoReader influxV9RepoReader, InfluxV9Utils influxV9Utils) {
        this.config = config;
        this.region = config.region;
        this.influxV9RepoReader = influxV9RepoReader;
        this.influxV9Utils = influxV9Utils;
    }

    @Override
    public List<DimensionValue> findValues(String metricName, String tenantId, String dimensionName, String offset, int limit) throws Exception {
        ArrayList<DimensionValue> dimensionValueList = new ArrayList<DimensionValue>();
        TreeSet<String> matchingValues = new TreeSet<String>();
        String dimNamePart = "and \"" + this.influxV9Utils.sanitize(dimensionName) + "\" =~ /.*/";
        String q = String.format("show series %1$s where %2$s %3$s", this.influxV9Utils.namePart(metricName, false), this.influxV9Utils.privateTenantIdPart(tenantId), dimNamePart);
        logger.debug("Dimension values query: {}", (Object)q);
        String r = this.influxV9RepoReader.read(q);
        Series series = (Series)this.objectMapper.readValue(r, Series.class);
        if (!series.isEmpty()) {
            for (Serie serie : series.getSeries()) {
                for (String[] values : serie.getValues()) {
                    Map<String, String> dimensions = this.influxV9Utils.getDimensions(values, serie.getColumns());
                    for (Map.Entry<String, String> entry : dimensions.entrySet()) {
                        if (!dimensionName.equals(entry.getKey())) continue;
                        matchingValues.add(entry.getValue());
                    }
                }
            }
        }
        List<String> filteredValues = this.filterDimensionValues(matchingValues, limit, offset);
        for (String filteredValue : filteredValues) {
            DimensionValue dimValue = new DimensionValue(metricName, dimensionName, filteredValue);
            dimensionValueList.add(dimValue);
        }
        return dimensionValueList;
    }

    private List<String> filterDimensionValues(Set<String> matchingValues, int limit, String offset) {
        Boolean haveOffset = !Strings.isNullOrEmpty((String)offset);
        ArrayList<String> filteredValues = new ArrayList<String>();
        int remaining_limit = limit + 1;
        for (String dimVal : matchingValues) {
            if (remaining_limit <= 0) break;
            if (haveOffset.booleanValue() && dimVal.compareTo(offset) <= 0) continue;
            filteredValues.add(dimVal);
            --remaining_limit;
        }
        return filteredValues;
    }

    @Override
    public List<DimensionName> findNames(String metricName, String tenantId, String offset, int limit) throws Exception {
        ArrayList<DimensionName> dimensionNameList = new ArrayList<DimensionName>();
        TreeSet<String> matchingNames = new TreeSet<String>();
        String q = String.format("show series %1$s where %2$s", this.influxV9Utils.namePart(metricName, false), this.influxV9Utils.privateTenantIdPart(tenantId));
        logger.debug("Dimension names query: {}", (Object)q);
        String r = this.influxV9RepoReader.read(q);
        Series series = (Series)this.objectMapper.readValue(r, Series.class);
        if (!series.isEmpty()) {
            for (Serie serie : series.getSeries()) {
                for (String[] names : serie.getValues()) {
                    Map<String, String> dimensions = this.influxV9Utils.getDimensions(names, serie.getColumns());
                    for (Map.Entry<String, String> entry : dimensions.entrySet()) {
                        matchingNames.add(entry.getKey());
                    }
                }
            }
        }
        List<String> filteredNames = this.filterDimensionNames(matchingNames, limit, offset);
        for (String filteredName : filteredNames) {
            DimensionName dimName = new DimensionName(metricName, filteredName);
            dimensionNameList.add(dimName);
        }
        return dimensionNameList;
    }

    private List<String> filterDimensionNames(Set<String> matchingNames, int limit, String offset) {
        Boolean haveOffset = !Strings.isNullOrEmpty((String)offset);
        ArrayList<String> filteredNames = new ArrayList<String>();
        int remaining_limit = limit + 1;
        for (String dimName : matchingNames) {
            if (remaining_limit <= 0) break;
            if (haveOffset.booleanValue() && dimName.compareTo(offset) <= 0) continue;
            filteredNames.add(dimName);
            --remaining_limit;
        }
        return filteredNames;
    }
}

