/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.ApiConfig;
import monasca.api.app.MetricService;
import monasca.api.app.command.CreateMetricCommand;
import monasca.api.app.validation.MetricNameValidation;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.metric.MetricDefinitionRepo;
import monasca.api.domain.model.metric.MetricName;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.resource.Links;
import monasca.api.resource.exception.Exceptions;
import monasca.common.model.Services;
import monasca.common.model.metric.Metric;
import monasca.common.model.metric.MetricDefinition;
import org.joda.time.DateTime;

@Path(value="/v2.0/metrics")
public class MetricResource {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private final String monitoring_delegate_role;
    private final String admin_role;
    private final MetricService service;
    private final MetricDefinitionRepo metricRepo;
    private final PersistUtils persistUtils;

    @Inject
    public MetricResource(ApiConfig config, MetricService service, MetricDefinitionRepo metricRepo, PersistUtils persistUtils) {
        this.monitoring_delegate_role = config.middleware == null || config.middleware.delegateAuthorizedRole == null ? "monitoring-delegate" : config.middleware.delegateAuthorizedRole;
        this.admin_role = config.middleware == null || config.middleware.adminRole == null ? "monasca-admin" : config.middleware.adminRole;
        this.service = service;
        this.metricRepo = metricRepo;
        this.persistUtils = persistUtils;
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    public void create(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @HeaderParam(value="X-Roles") String roles, @QueryParam(value="tenant_id") String crossTenantId, @Valid CreateMetricCommand[] commands) {
        boolean isDelegate = !Strings.isNullOrEmpty((String)roles) && COMMA_SPLITTER.splitToList((CharSequence)roles).contains(this.monitoring_delegate_role);
        boolean isAdmin = !Strings.isNullOrEmpty((String)roles) && COMMA_SPLITTER.splitToList((CharSequence)roles).contains(this.admin_role);
        ArrayList<Metric> metrics = new ArrayList<Metric>(commands.length);
        for (CreateMetricCommand command : commands) {
            if (!isDelegate) {
                String service;
                if (command.dimensions != null && (service = command.dimensions.get("service")) != null && Services.isReserved((String)service)) {
                    throw Exceptions.forbidden("Project %s cannot POST metrics for the hpcs service", tenantId);
                }
                if (Validation.isCrossProjectRequest(crossTenantId, tenantId)) {
                    throw Exceptions.forbidden("Project %s cannot POST cross tenant metrics", tenantId);
                }
            }
            command.validate(!isAdmin);
            metrics.add(command.toMetric());
        }
        this.service.create(metrics, tenantId, crossTenantId);
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object getMetrics(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @HeaderParam(value="X-Roles") String roles, @QueryParam(value="name") String name, @QueryParam(value="dimensions") String dimensionsStr, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit, @QueryParam(value="start_time") String startTimeStr, @QueryParam(value="end_time") String endTimeStr, @QueryParam(value="tenant_id") String crossTenantId) throws Exception {
        Map<String, String> dimensions = Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseAndValidateDimensions(dimensionsStr);
        MetricNameValidation.validate(name, false);
        DateTime startTime = Validation.parseAndValidateDate(startTimeStr, "start_time", false);
        DateTime endTime = Validation.parseAndValidateDate(endTimeStr, "end_time", false);
        if (startTime != null && endTime != null) {
            Validation.validateTimes(startTime, endTime);
        }
        String queryTenantId = Validation.getQueryProject(roles, crossTenantId, tenantId, this.admin_role);
        int paging_limit = this.persistUtils.getLimit(limit);
        List<MetricDefinition> resources = this.metricRepo.find(queryTenantId, name, dimensions, startTime, endTime, offset, paging_limit);
        return Links.paginate(paging_limit, resources, uriInfo);
    }

    @GET
    @Path(value="/names")
    @Timed
    @Produces(value={"application/json"})
    public Object getMetricNames(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @HeaderParam(value="X-Roles") String roles, @QueryParam(value="dimensions") String dimensionsStr, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit, @QueryParam(value="tenant_id") String crossTenantId) throws Exception {
        Map<String, String> dimensions = Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseAndValidateDimensions(dimensionsStr);
        String queryTenantId = Validation.getQueryProject(roles, crossTenantId, tenantId, this.admin_role);
        int paging_limit = this.persistUtils.getLimit(limit);
        List<MetricName> resources = this.metricRepo.findNames(queryTenantId, dimensions, offset, paging_limit);
        return Links.paginate(paging_limit, resources, uriInfo);
    }
}

