/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.hibernate;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.exception.EntityNotFoundException;
import monasca.api.domain.model.alarmdefinition.AlarmDefinition;
import monasca.api.domain.model.alarmdefinition.AlarmDefinitionRepo;
import monasca.api.infrastructure.persistence.SubAlarmDefinitionQueries;
import monasca.api.infrastructure.persistence.hibernate.BaseSqlRepo;
import monasca.common.hibernate.db.AlarmActionDb;
import monasca.common.hibernate.db.AlarmDefinitionDb;
import monasca.common.hibernate.db.SubAlarmDefinitionDb;
import monasca.common.hibernate.db.SubAlarmDefinitionDimensionDb;
import monasca.common.hibernate.db.SubAlarmDefinitionDimensionId;
import monasca.common.model.alarm.AggregateFunction;
import monasca.common.model.alarm.AlarmOperator;
import monasca.common.model.alarm.AlarmSeverity;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmSubExpression;
import monasca.common.model.metric.MetricDefinition;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmDefinitionSqlRepoImpl
extends BaseSqlRepo
implements AlarmDefinitionRepo {
    private static final ResultTransformer ALARM_DEF_RESULT_TRANSFORMER = AlarmDefinitionSqlRepoImpl.getAlarmDefResultTransformer();
    private static final String ID = "ID";
    private static final String NAME = "NAME";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String EXPRESSION = "EXPRESSION";
    private static final String SEVERITY = "SEVERITY";
    private static final String MATCH_BY = "MATCH_BY";
    private static final String ACTIONS_ENABLED = "ACTIONS_ENABLED";
    private static final String STATE = "STATE";
    private static final String NOTIFICATION_ID = "NOTIFICATIONIDS";
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Logger logger = LoggerFactory.getLogger(AlarmDefinitionSqlRepoImpl.class);
    private static final String FIND_ALARM_DEF_SQL = "SELECT t.id, t.tenant_id, t.name, t.description, t.expression, t.severity, t.match_by, t.actions_enabled, aa.alarm_state AS state, aa.action_id AS notificationIds FROM (SELECT distinct ad.id, ad.tenant_id, ad.name, ad.description, ad.expression, ad.severity, ad.match_by, ad.actions_enabled, ad.created_at, ad.updated_at, ad.deleted_at FROM alarm_definition AS ad LEFT OUTER JOIN sub_alarm_definition AS sad ON ad.id = sad.alarm_definition_id LEFT OUTER JOIN sub_alarm_definition_dimension AS dim ON sad.id = dim.sub_alarm_definition_id %1$s WHERE ad.tenant_id = :tenantId AND ad.deleted_at IS NULL %2$s ORDER BY ad.id %3$s) AS t LEFT OUTER JOIN alarm_action AS aa ON t.id = aa.alarm_definition_id %4$s";

    @Inject
    public AlarmDefinitionSqlRepoImpl(@Named(value="orm") SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public AlarmDefinition create(String tenantId, String id, String name, String description, String severity, String expression, Map<String, AlarmSubExpression> subExpressions, List<String> matchBy, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        logger.trace(ORM_LOG_MARKER, "create(...) entering...");
        Transaction tx = null;
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            DateTime now = this.getUTCNow();
            AlarmDefinitionDb alarmDefinition = new AlarmDefinitionDb(id, tenantId, name, description, expression, AlarmSeverity.valueOf((String)severity.toUpperCase()), matchBy == null || Iterables.isEmpty(matchBy) ? null : COMMA_JOINER.join(matchBy), true, now, now, null);
            session.save((Object)alarmDefinition);
            this.createSubExpressions(session, alarmDefinition, subExpressions);
            this.persistActions(session, alarmDefinition, AlarmState.ALARM, alarmActions);
            this.persistActions(session, alarmDefinition, AlarmState.OK, okActions);
            this.persistActions(session, alarmDefinition, AlarmState.UNDETERMINED, undeterminedActions);
            tx.commit();
            tx = null;
            logger.debug(ORM_LOG_MARKER, "AlarmDefinition [ {} ] has been committed to database", (Object)alarmDefinition);
            AlarmDefinition alarmDefinition2 = new AlarmDefinition(id, name, description, severity, expression, matchBy, true, alarmActions == null ? Collections.emptyList() : alarmActions, okActions == null ? Collections.emptyList() : okActions, undeterminedActions == null ? Collections.emptyList() : undeterminedActions);
            return alarmDefinition2;
        }
    }

    @Override
    public void deleteById(String tenantId, String alarmDefId) {
        logger.trace(ORM_LOG_MARKER, "deleteById(...) entering...");
        Transaction tx = null;
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            AlarmDefinitionDb result = (AlarmDefinitionDb)session.getNamedQuery("AlarmDefinition.byTenantAndIdNotDeleted").setString("tenant_id", tenantId).setString("id", alarmDefId).uniqueResult();
            result.setDeletedAt(this.getUTCNow());
            session.update((Object)result);
            session.getNamedQuery("Alarm.deleteByAlarmDefinitionId").setString("alarmDefinitionId", alarmDefId).executeUpdate();
            tx.commit();
            tx = null;
            logger.debug(ORM_LOG_MARKER, "AlarmDefinition [ {} ] has been deleted from database", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String exists(String tenantId, String name) {
        logger.trace(ORM_LOG_MARKER, "exists(...) entering...");
        try (StatelessSession session = null;){
            String existingId;
            session = this.sessionFactory.openStatelessSession();
            List ids = session.createCriteria(AlarmDefinitionDb.class).add((Criterion)Restrictions.eq((String)"tenantId", (Object)tenantId)).add((Criterion)Restrictions.eq((String)"name", (Object)name)).add(Restrictions.isNull((String)"deletedAt")).setProjection((Projection)Projections.property((String)"id")).setMaxResults(1).list();
            String string = existingId = CollectionUtils.isEmpty((Collection)ids) ? null : (String)ids.get(0);
            if (null == existingId) {
                logger.debug(ORM_LOG_MARKER, "No AlarmDefinition matched tenantId={} and name={}", (Object)tenantId, (Object)name);
            }
            String string2 = existingId;
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlarmDefinition> find(String tenantId, String name, Map<String, String> dimensions, List<AlarmSeverity> severities, List<String> sortBy, String offset, int limit) {
        logger.trace(ORM_LOG_MARKER, "find(...) entering...");
        Session session = null;
        ArrayList resultSet = Lists.newArrayList();
        StringBuilder sbWhere = new StringBuilder();
        StringBuilder limitOffset = new StringBuilder();
        StringBuilder orderByPart = new StringBuilder();
        if (name != null) {
            sbWhere.append(" and ad.name = :name");
        }
        if (CollectionUtils.isNotEmpty(severities)) {
            if (severities.size() == 1) {
                sbWhere.append(" and ad.severity = :severity");
            } else {
                sbWhere.append(" and (");
                for (int i = 0; i < severities.size(); ++i) {
                    sbWhere.append("ad.severity = :severity_").append(i);
                    if (i >= severities.size() - 1) continue;
                    sbWhere.append(" or ");
                }
                sbWhere.append(")");
            }
        }
        if (limit > 0) {
            limitOffset.append(" limit :limit");
        }
        if (offset != null) {
            limitOffset.append(" offset :offset ");
        }
        if (sortBy != null && !sortBy.isEmpty()) {
            orderByPart.append(" order by ").append(COMMA_JOINER.join(sortBy));
            if (!sortBy.contains("id")) {
                orderByPart.append(",id");
            }
        } else {
            orderByPart.append(" order by id ");
        }
        String sql = String.format(FIND_ALARM_DEF_SQL, SubAlarmDefinitionQueries.buildJoinClauseFor(dimensions), sbWhere, limitOffset, orderByPart);
        try {
            session = this.sessionFactory.openSession();
            Query qAlarmDefinition = session.createSQLQuery(sql).setString("tenantId", tenantId).setReadOnly(true).setResultTransformer(ALARM_DEF_RESULT_TRANSFORMER);
            if (name != null) {
                qAlarmDefinition.setString("name", name);
            }
            if (CollectionUtils.isNotEmpty(severities)) {
                if (severities.size() == 1) {
                    qAlarmDefinition.setString("severity", severities.get(0).name());
                } else {
                    for (int it = 0; it < severities.size(); ++it) {
                        qAlarmDefinition.setString(String.format("severity_%d", it), severities.get(it).name());
                    }
                }
            }
            if (limit > 0) {
                qAlarmDefinition.setInteger("limit", limit + 1);
            }
            if (offset != null) {
                qAlarmDefinition.setInteger("offset", Integer.parseInt(offset));
            }
            this.bindDimensionsToQuery(qAlarmDefinition, dimensions);
            List alarmDefinitionDbList = qAlarmDefinition.list();
            resultSet = CollectionUtils.isEmpty((Collection)alarmDefinitionDbList) ? Lists.newArrayList() : this.createAlarmDefinitions(alarmDefinitionDbList);
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlarmDefinition findById(String tenantId, String alarmDefId) {
        logger.trace(ORM_LOG_MARKER, "findById(...) entering...");
        Session session = null;
        ArrayList okActionIds = null;
        ArrayList alarmActionIds = null;
        ArrayList undeterminedActionIds = null;
        try {
            session = this.sessionFactory.openSession();
            AlarmDefinitionDb alarmDefinitionDb = (AlarmDefinitionDb)session.getNamedQuery("AlarmDefinition.byTenantAndIdNotDeleted").setString("tenant_id", tenantId).setString("id", alarmDefId).uniqueResult();
            if (alarmDefinitionDb == null) {
                throw new EntityNotFoundException("No alarm definition exists for tenantId=%s and id=%s", tenantId, alarmDefId);
            }
            List alarmActionList = session.getNamedQuery("AlarmAction.findByTenantIdAndAlarmDefinitionId.Distinct").setString("tenantId", tenantId).setString("alarmDefId", alarmDefId).list();
            if (!CollectionUtils.isEmpty((Collection)alarmActionList)) {
                logger.debug(ORM_LOG_MARKER, "Located {} AlarmActions for AlarmDefinition {}", (Object)alarmActionList.size(), (Object)alarmDefinitionDb);
                okActionIds = Lists.newArrayList();
                alarmActionIds = Lists.newArrayList();
                undeterminedActionIds = Lists.newArrayList();
                for (AlarmActionDb alarmAction : alarmActionList) {
                    if (alarmAction.isInAlarmState(AlarmState.UNDETERMINED)) {
                        undeterminedActionIds.add(alarmAction.getAlarmActionId().getActionId());
                        continue;
                    }
                    if (alarmAction.isInAlarmState(AlarmState.OK)) {
                        okActionIds.add(alarmAction.getAlarmActionId().getActionId());
                        continue;
                    }
                    if (!alarmAction.isInAlarmState(AlarmState.ALARM)) continue;
                    alarmActionIds.add(alarmAction.getAlarmActionId().getActionId());
                }
            }
            AlarmDefinition alarmDefinition = new AlarmDefinition((String)((Object)alarmDefinitionDb.getId()), alarmDefinitionDb.getName(), alarmDefinitionDb.getDescription(), alarmDefinitionDb.getSeverity().name(), alarmDefinitionDb.getExpression(), this.splitStringIntoList(alarmDefinitionDb.getMatchBy()), alarmDefinitionDb.isActionsEnabled(), alarmActionIds == null ? Collections.emptyList() : alarmActionIds, okActionIds == null ? Collections.emptyList() : okActionIds, undeterminedActionIds == null ? Collections.emptyList() : undeterminedActionIds);
            return alarmDefinition;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, MetricDefinition> findSubAlarmMetricDefinitions(String alarmDefId) {
        logger.trace(ORM_LOG_MARKER, "findSubAlarmMetricDefinitions(...) entering...");
        HashMap subAlarmMetricDefs = Maps.newHashMap();
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            List subAlarmDefList = session.getNamedQuery("SubAlarmDefinition.byAlarmDefinitionId").setString("id", alarmDefId).list();
            List subAlarmDefDimensionList = session.getNamedQuery("SubAlarmDefinition.byAlarmDefinitionDimension.subExpressionId").setString("id", alarmDefId).list();
            Map<String, Map<String, String>> subAlarmDefDimensionMapExpression = this.mapAlarmDefDimensionExpression(subAlarmDefDimensionList);
            for (SubAlarmDefinitionDb subAlarmDef : subAlarmDefList) {
                String id = (String)((Object)subAlarmDef.getId());
                String metricName = subAlarmDef.getMetricName();
                Map<Object, Object> dimensions = Collections.emptyMap();
                if (subAlarmDefDimensionMapExpression.containsKey(id)) {
                    dimensions = subAlarmDefDimensionMapExpression.get(id);
                }
                subAlarmMetricDefs.put(id, new MetricDefinition(metricName, dimensions));
            }
            HashMap hashMap = subAlarmMetricDefs;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, AlarmSubExpression> findSubExpressions(String alarmDefId) {
        logger.trace(ORM_LOG_MARKER, "findSubExpressions(...) entering...");
        HashMap subExpressions = Maps.newHashMap();
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            List subAlarmDefList = session.getNamedQuery("SubAlarmDefinition.byAlarmDefinitionId").setString("id", alarmDefId).list();
            Query querySybAlarmDefDimension = session.getNamedQuery("SubAlarmDefinition.byAlarmDefinitionDimension.subExpressionId").setString("id", alarmDefId);
            List subAlarmDefDimensionList = querySybAlarmDefDimension.list();
            Map<String, Map<String, String>> subAlarmDefDimensionMapExpression = this.mapAlarmDefDimensionExpression(subAlarmDefDimensionList);
            for (SubAlarmDefinitionDb subAlarmDef : subAlarmDefList) {
                String id = (String)((Object)subAlarmDef.getId());
                AggregateFunction function = AggregateFunction.fromJson((String)subAlarmDef.getFunction());
                String metricName = subAlarmDef.getMetricName();
                AlarmOperator operator = AlarmOperator.fromJson((String)subAlarmDef.getOperator());
                double threshold = subAlarmDef.getThreshold();
                int period = subAlarmDef.getPeriod();
                int periods = subAlarmDef.getPeriods();
                boolean isDeterministic = subAlarmDef.isDeterministic();
                Map<Object, Object> dimensions = Collections.emptyMap();
                if (subAlarmDefDimensionMapExpression.containsKey(id)) {
                    dimensions = subAlarmDefDimensionMapExpression.get(id);
                }
                subExpressions.put(id, new AlarmSubExpression(function, new MetricDefinition(metricName, dimensions), operator, threshold, period, periods, isDeterministic));
            }
            HashMap hashMap = subExpressions;
            return hashMap;
        }
    }

    @Override
    public void update(String tenantId, String id, boolean patch, String name, String description, String expression, List<String> matchBy, String severity, boolean actionsEnabled, Collection<String> oldSubAlarmIds, Map<String, AlarmSubExpression> changedSubAlarms, Map<String, AlarmSubExpression> newSubAlarms, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions) {
        logger.trace(ORM_LOG_MARKER, "update(...) entering...");
        Transaction tx = null;
        try (Session session = null;){
            session = this.sessionFactory.openSession();
            tx = session.beginTransaction();
            AlarmDefinitionDb alarmDefinitionDb = this.updateAlarmDefinition(tenantId, id, name, description, expression, matchBy, severity, actionsEnabled, session);
            this.deleteOldSubAlarms(oldSubAlarmIds, session);
            this.updateChangedSubAlarms(changedSubAlarms, session);
            this.createSubExpressions(session, alarmDefinitionDb, newSubAlarms);
            this.deleteOldAlarmActions(id, patch, alarmActions, okActions, undeterminedActions, session);
            this.persistActions(session, alarmDefinitionDb, AlarmState.ALARM, alarmActions);
            this.persistActions(session, alarmDefinitionDb, AlarmState.OK, okActions);
            this.persistActions(session, alarmDefinitionDb, AlarmState.UNDETERMINED, undeterminedActions);
            tx.commit();
            tx = null;
        }
    }

    private void deleteOldAlarmActions(String id, boolean patch, List<String> alarmActions, List<String> okActions, List<String> undeterminedActions, Session session) {
        if (patch) {
            this.deleteActions(session, id, AlarmState.ALARM, alarmActions);
            this.deleteActions(session, id, AlarmState.OK, okActions);
            this.deleteActions(session, id, AlarmState.UNDETERMINED, undeterminedActions);
        } else {
            session.getNamedQuery("AlarmAction.deleteByAlarmDefinitionId").setString("id", id).executeUpdate();
        }
    }

    private void updateChangedSubAlarms(Map<String, AlarmSubExpression> changedSubAlarms, Session session) {
        if (!MapUtils.isEmpty(changedSubAlarms)) {
            for (Map.Entry<String, AlarmSubExpression> entry : changedSubAlarms.entrySet()) {
                AlarmSubExpression sa = entry.getValue();
                String subAlarmDefinitionId = entry.getKey();
                SubAlarmDefinitionDb subAlarmDefinitionDb = (SubAlarmDefinitionDb)session.get(SubAlarmDefinitionDb.class, (Serializable)((Object)subAlarmDefinitionId));
                subAlarmDefinitionDb.setOperator(sa.getOperator().name());
                subAlarmDefinitionDb.setThreshold(Double.valueOf(sa.getThreshold()));
                subAlarmDefinitionDb.setUpdatedAt(this.getUTCNow());
                subAlarmDefinitionDb.setDeterministic(sa.isDeterministic());
                session.saveOrUpdate((Object)subAlarmDefinitionDb);
            }
        }
    }

    private void deleteOldSubAlarms(Collection<String> oldSubAlarmIds, Session session) {
        if (!CollectionUtils.isEmpty(oldSubAlarmIds)) {
            session.getNamedQuery("SubAlarmDefinition.deleteByIds").setParameterList("ids", oldSubAlarmIds).executeUpdate();
        }
    }

    private AlarmDefinitionDb updateAlarmDefinition(String tenantId, String id, String name, String description, String expression, List<String> matchBy, String severity, boolean actionsEnabled, Session session) {
        AlarmDefinitionDb alarmDefinitionDb = (AlarmDefinitionDb)session.getNamedQuery("AlarmDefinition.byTenantIdAndId").setString("tenantId", tenantId).setString("id", id).uniqueResult();
        alarmDefinitionDb.setName(name);
        alarmDefinitionDb.setDescription(description);
        alarmDefinitionDb.setExpression(expression);
        alarmDefinitionDb.setMatchBy(matchBy == null || Iterables.isEmpty(matchBy) ? null : COMMA_JOINER.join(matchBy));
        alarmDefinitionDb.setSeverity(AlarmSeverity.valueOf((String)severity));
        alarmDefinitionDb.setActionsEnabled(actionsEnabled);
        alarmDefinitionDb.setUpdatedAt(this.getUTCNow());
        session.saveOrUpdate((Object)alarmDefinitionDb);
        return alarmDefinitionDb;
    }

    private void deleteActions(Session session, String id, AlarmState alarmState, List<String> actions) {
        if (!CollectionUtils.isEmpty(actions)) {
            session.getNamedQuery("AlarmAction.deleteByAlarmDefinitionIdAndAlarmState").setString("id", id).setString("alarmState", alarmState.name()).executeUpdate();
        }
    }

    private Map<String, Map<String, String>> mapAlarmDefDimensionExpression(List<SubAlarmDefinitionDimensionDb> subAlarmDefDimensionList) {
        HashMap subAlarmDefDimensionMapExpression = Maps.newHashMapWithExpectedSize((int)subAlarmDefDimensionList.size());
        for (SubAlarmDefinitionDimensionDb subAlarmDefDimension : subAlarmDefDimensionList) {
            String subAlarmDefId = (String)((Object)subAlarmDefDimension.getSubAlarmDefinitionDimensionId().getSubExpression().getId());
            String name = subAlarmDefDimension.getSubAlarmDefinitionDimensionId().getDimensionName();
            String value = subAlarmDefDimension.getValue();
            if (subAlarmDefDimensionMapExpression.containsKey(subAlarmDefId)) {
                ((Map)subAlarmDefDimensionMapExpression.get(subAlarmDefId)).put(name, value);
                continue;
            }
            HashMap expressionMap = Maps.newHashMap();
            expressionMap.put(name, value);
            subAlarmDefDimensionMapExpression.put(subAlarmDefId, expressionMap);
        }
        return subAlarmDefDimensionMapExpression;
    }

    private void bindDimensionsToQuery(Query query, Map<String, String> dimensions) {
        if (dimensions != null) {
            int i = 0;
            for (Map.Entry<String, String> entry : dimensions.entrySet()) {
                query.setString("dname" + i, entry.getKey());
                query.setString("dvalue" + i, entry.getValue());
                ++i;
            }
        }
    }

    private List<AlarmDefinition> createAlarmDefinitions(List<Map<?, ?>> rows) {
        String alarmDefId;
        ArrayList<AlarmDefinition> result = new ArrayList<AlarmDefinition>();
        HashMap okActionIdsMap = Maps.newHashMap();
        HashMap alarmActionIdsMap = Maps.newHashMap();
        HashMap undeterminedActionIdsMap = Maps.newHashMap();
        HashSet alarmDefinitionSet = Sets.newHashSet();
        for (Map<?, ?> row : rows) {
            alarmDefId = (String)row.get(ID);
            String singleState = (String)row.get(STATE);
            String notificationId = (String)row.get(NOTIFICATION_ID);
            if (!okActionIdsMap.containsKey(alarmDefId)) {
                okActionIdsMap.put(alarmDefId, Lists.newArrayList());
            }
            if (!alarmActionIdsMap.containsKey(alarmDefId)) {
                alarmActionIdsMap.put(alarmDefId, Lists.newArrayList());
            }
            if (!undeterminedActionIdsMap.containsKey(alarmDefId)) {
                undeterminedActionIdsMap.put(alarmDefId, Lists.newArrayList());
            }
            if (singleState == null || notificationId == null) continue;
            if (singleState.equals(AlarmState.UNDETERMINED.name())) {
                ((List)undeterminedActionIdsMap.get(alarmDefId)).add(notificationId);
            }
            if (singleState.equals(AlarmState.OK.name())) {
                ((List)okActionIdsMap.get(alarmDefId)).add(notificationId);
            }
            if (!singleState.equals(AlarmState.ALARM.name())) continue;
            ((List)alarmActionIdsMap.get(alarmDefId)).add(notificationId);
        }
        for (Map<?, ?> row : rows) {
            alarmDefId = (String)row.get(ID);
            if (!alarmDefinitionSet.contains(alarmDefId)) {
                String name = (String)row.get(NAME);
                String description = (String)row.get(DESCRIPTION);
                String severity = (String)row.get(SEVERITY);
                String expression = (String)row.get(EXPRESSION);
                List<String> match = this.splitStringIntoList((String)row.get(MATCH_BY));
                Boolean actionEnabled = (Boolean)row.get(ACTIONS_ENABLED);
                AlarmDefinition ad = new AlarmDefinition(alarmDefId, name, description, severity, expression, match, actionEnabled, (List)alarmActionIdsMap.get(alarmDefId), (List)okActionIdsMap.get(alarmDefId), (List)undeterminedActionIdsMap.get(alarmDefId));
                result.add(ad);
            }
            alarmDefinitionSet.add(alarmDefId);
        }
        return result;
    }

    private List<String> splitStringIntoList(String str) {
        return str == null ? Lists.newArrayList() : Lists.newArrayList((Iterable)COMMA_SPLITTER.split((CharSequence)str));
    }

    private void createSubExpressions(Session session, AlarmDefinitionDb alarmDefinition, Map<String, AlarmSubExpression> alarmSubExpressions) {
        if (alarmSubExpressions != null) {
            for (Map.Entry<String, AlarmSubExpression> subEntry : alarmSubExpressions.entrySet()) {
                String subAlarmId = subEntry.getKey();
                AlarmSubExpression subExpr = subEntry.getValue();
                MetricDefinition metricDef = subExpr.getMetricDefinition();
                DateTime now = this.getUTCNow();
                SubAlarmDefinitionDb subAlarmDefinitionDb = new SubAlarmDefinitionDb(subAlarmId, alarmDefinition, subExpr.getFunction().name(), metricDef.name, subExpr.getOperator().name(), Double.valueOf(subExpr.getThreshold()), Integer.valueOf(subExpr.getPeriod()), Integer.valueOf(subExpr.getPeriods()), now, now, subExpr.isDeterministic());
                session.save((Object)subAlarmDefinitionDb);
                if (MapUtils.isEmpty((Map)metricDef.dimensions)) continue;
                for (Map.Entry dimEntry : metricDef.dimensions.entrySet()) {
                    SubAlarmDefinitionDimensionId definitionDimensionId = new SubAlarmDefinitionDimensionId(subAlarmDefinitionDb, (String)dimEntry.getKey());
                    SubAlarmDefinitionDimensionDb definitionDimension = new SubAlarmDefinitionDimensionDb(definitionDimensionId, (String)dimEntry.getValue());
                    session.save((Object)definitionDimension);
                }
            }
        }
    }

    private void persistActions(Session session, AlarmDefinitionDb alarmDefinition, AlarmState alarmState, List<String> actions) {
        if (actions != null) {
            for (String action : actions) {
                session.save((Object)new AlarmActionDb(alarmDefinition, alarmState, action));
            }
        }
    }

    private static ResultTransformer getAlarmDefResultTransformer() {
        return new ResultTransformer(){
            private static final long serialVersionUID = -3052468375925339521L;

            public Object transformTuple(Object[] tuple, String[] aliases) {
                int length = aliases.length;
                for (int i = 0; i < length; ++i) {
                    aliases[i] = aliases[i].toUpperCase();
                }
                return AliasToEntityMapResultTransformer.INSTANCE.transformTuple(tuple, aliases);
            }

            public List transformList(List collection) {
                return AliasToEntityMapResultTransformer.INSTANCE.transformList(collection);
            }
        };
    }
}

