/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.vertica;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.domain.model.alarmstatehistory.AlarmStateHistory;
import monasca.api.domain.model.alarmstatehistory.AlarmStateHistoryRepo;
import monasca.api.infrastructure.persistence.DimensionQueries;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.infrastructure.persistence.Utils;
import monasca.common.model.alarm.AlarmState;
import monasca.common.model.alarm.AlarmTransitionSubAlarm;
import monasca.common.model.metric.MetricDefinition;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmStateHistoryVerticaRepoImpl
implements AlarmStateHistoryRepo {
    private static final Logger logger = LoggerFactory.getLogger(AlarmStateHistoryVerticaRepoImpl.class);
    private static final String FIND_BY_ALARM_IDS_SQL = "select alarm_id, metrics, old_state, new_state, reason, reason_data, sub_alarms, time_stamp as timestamp from MonAlarms.StateHistory where tenant_id = :tenantId %s order by time_stamp asc limit :limit";
    private static final String FIND_BY_ALARM_ID_SQL = "select alarm_id, metrics, old_state, new_state, reason, reason_data, sub_alarms, time_stamp as timestamp from MonAlarms.StateHistory where tenant_id = :tenantId and alarm_id = :alarmId %s order by time_stamp asc limit :limit";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final TypeReference<List<MetricDefinition>> METRICS_TYPE;
    private static final TypeReference<List<AlarmTransitionSubAlarm>> SUB_ALARMS_TYPE;
    private final DBI vertica;
    private final Utils utils;
    private final PersistUtils persistUtils;
    private final ThreadLocal<SimpleDateFormat> simpleDateFormatter;

    @Inject
    public AlarmStateHistoryVerticaRepoImpl(@Named(value="vertica") DBI vertica, Utils utils, PersistUtils persistUtils) {
        this.vertica = vertica;
        this.utils = utils;
        this.persistUtils = persistUtils;
        this.simpleDateFormatter = new ThreadLocal();
    }

    @Override
    public List<AlarmStateHistory> findById(String tenantId, String alarmId, String offset, int limit) {
        String offsetPart = "";
        if (offset != null && !offset.isEmpty()) {
            offsetPart = " and time_stamp > :offset";
        }
        String sql = String.format(FIND_BY_ALARM_ID_SQL, offsetPart);
        logger.debug("vertica sql: {}", (Object)sql);
        ArrayList<AlarmStateHistory> alarmStateHistoryList = new ArrayList<AlarmStateHistory>();
        try (Handle h = this.vertica.open();){
            Query verticaQuery = (Query)((Query)((Query)h.createQuery(sql).bind("tenantId", tenantId)).bind("alarmId", alarmId)).bind("limit", limit + 1);
            if (offset != null && !offset.isEmpty()) {
                DateTime offset_dt = new DateTime((Object)offset);
                verticaQuery.bind("offset", this.formatDateFromMillis(offset_dt.getMillis()));
            }
            for (Map row : verticaQuery.list()) {
                alarmStateHistoryList.add(this.getAlarmStateHistory(row));
            }
            ArrayList<AlarmStateHistory> arrayList = alarmStateHistoryList;
            return arrayList;
        }
    }

    private String formatDateFromMillis(long millis) {
        if (this.simpleDateFormatter.get() == null) {
            this.simpleDateFormatter.set(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
            this.simpleDateFormatter.get().setTimeZone(TimeZone.getTimeZone("GMT-0"));
        }
        return this.simpleDateFormatter.get().format(new Date(millis));
    }

    @Override
    public List<AlarmStateHistory> find(String tenantId, Map<String, String> dimensions, DateTime startTime, @Nullable DateTime endTime, @Nullable String offset, int limit) {
        List<String> alarmIds = this.utils.findAlarmIds(tenantId, dimensions);
        if (alarmIds == null || alarmIds.isEmpty()) {
            logger.debug("list of alarm ids is empty");
            return Collections.emptyList();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" and alarm_id in (");
        for (int i = 0; i < alarmIds.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('\'').append(alarmIds.get(i)).append('\'');
        }
        sb.append(')');
        if (startTime != null) {
            sb.append(" and time_stamp >= :startTime");
        }
        if (endTime != null) {
            sb.append(" and time_stamp <= :endTime");
        }
        if (offset != null && !offset.isEmpty()) {
            sb.append(" and time_stamp > :offset");
        }
        String sql = String.format(FIND_BY_ALARM_IDS_SQL, sb);
        logger.debug("vertica sql: {}", (Object)sql);
        ArrayList<AlarmStateHistory> alarmStateHistoryList = new ArrayList<AlarmStateHistory>();
        try (Handle h = this.vertica.open();){
            Query verticaQuery = (Query)((Query)h.createQuery(sql).bind("tenantId", tenantId)).bind("limit", limit + 1);
            if (startTime != null) {
                logger.debug("binding startime: {}", (Object)startTime);
                verticaQuery.bind("startTime", this.formatDateFromMillis(startTime.getMillis()));
            }
            if (endTime != null) {
                logger.debug("binding endtime: {}", (Object)endTime);
                verticaQuery.bind("endTime", this.formatDateFromMillis(endTime.getMillis()));
            }
            if (offset != null && !offset.isEmpty()) {
                logger.debug("binding offset: {}", (Object)offset);
                DateTime offset_dt = new DateTime((Object)offset);
                verticaQuery.bind("offset", this.formatDateFromMillis(offset_dt.getMillis()));
            }
            DimensionQueries.bindDimensionsToQuery(verticaQuery, dimensions);
            for (Map row : verticaQuery.list()) {
                alarmStateHistoryList.add(this.getAlarmStateHistory(row));
            }
        }
        return alarmStateHistoryList;
    }

    private AlarmStateHistory getAlarmStateHistory(Map<String, Object> row) {
        ArrayList<AlarmTransitionSubAlarm> subAlarmList;
        ArrayList<MetricDefinition> metricDefinitionList;
        Date date;
        AlarmStateHistory alarmStateHistory = new AlarmStateHistory();
        try {
            date = this.persistUtils.parseTimestamp(row.get("timestamp").toString() + "Z");
        }
        catch (ParseException e) {
            logger.error("Failed to parse time", (Throwable)e);
            return null;
        }
        DateTime dateTime = new DateTime(date.getTime(), DateTimeZone.UTC);
        alarmStateHistory.setTimestamp(dateTime);
        alarmStateHistory.setAlarmId((String)row.get("alarm_id"));
        try {
            metricDefinitionList = (ArrayList<MetricDefinition>)objectMapper.readValue((String)row.get("metrics"), METRICS_TYPE);
        }
        catch (IOException e) {
            logger.error("Failed to parse metrics", (Throwable)e);
            metricDefinitionList = new ArrayList<MetricDefinition>();
        }
        alarmStateHistory.setMetrics(metricDefinitionList);
        alarmStateHistory.setOldState(AlarmState.valueOf((String)((String)row.get("old_state"))));
        alarmStateHistory.setNewState(AlarmState.valueOf((String)((String)row.get("new_state"))));
        alarmStateHistory.setReason((String)row.get("reason"));
        alarmStateHistory.setReasonData((String)row.get("reason_data"));
        try {
            subAlarmList = (ArrayList<AlarmTransitionSubAlarm>)objectMapper.readValue((String)row.get("sub_alarms"), SUB_ALARMS_TYPE);
        }
        catch (IOException e) {
            logger.error("Failed to parse sub-alarms", (Throwable)e);
            subAlarmList = new ArrayList<AlarmTransitionSubAlarm>();
        }
        alarmStateHistory.setSubAlarms(subAlarmList);
        return alarmStateHistory;
    }

    static {
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        METRICS_TYPE = new TypeReference<List<MetricDefinition>>(){};
        SUB_ALARMS_TYPE = new TypeReference<List<AlarmTransitionSubAlarm>>(){};
    }
}

