/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.vertica;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.ApiConfig;
import monasca.api.domain.model.dimension.DimensionName;
import monasca.api.domain.model.dimension.DimensionRepo;
import monasca.api.domain.model.dimension.DimensionValue;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DimensionVerticaRepoImpl
implements DimensionRepo {
    private static final Logger logger = LoggerFactory.getLogger(DimensionVerticaRepoImpl.class);
    private static final String FIND_DIMENSION_VALUES_SQL = "SELECT %s  DISTINCT dims.value as dValue FROM   MonMetrics.Definitions def,  MonMetrics.DefinitionDimensions defdims LEFT OUTER JOIN  MonMetrics.Dimensions dims    ON dims.dimension_set_id = defdims.dimension_set_id WHERE  def.id = defdims.definition_id  %s   %s   and def.tenant_id = '%s'  and dims.name = '%s' ORDER BY dims.value ASC %s ";
    private static final String FIND_DIMENSION_NAMES_SQL = "SELECT %s  DISTINCT dims.name as dName FROM   MonMetrics.Definitions def,  MonMetrics.DefinitionDimensions defdims LEFT OUTER JOIN  MonMetrics.Dimensions dims    ON dims.dimension_set_id = defdims.dimension_set_id WHERE   def.id = defdims.definition_id  %s   %s   and def.tenant_id = '%s' ORDER BY dims.name ASC %s ";
    private final DBI db;
    private final String dbHint;

    @Inject
    public DimensionVerticaRepoImpl(@Named(value="vertica") DBI db, ApiConfig config) {
        this.db = db;
        this.dbHint = config.vertica.dbHint;
    }

    @Override
    public List<DimensionValue> findValues(String metricName, String tenantId, String dimensionName, String offset, int limit) throws Exception {
        String offsetPart = "";
        String metricNamePart = "";
        try (Handle h = this.db.open();){
            if (offset != null && !offset.isEmpty()) {
                offsetPart = " and dims.value > :offset";
            }
            if (metricName != null && !metricName.isEmpty()) {
                metricNamePart = " and def.name = :metricName";
            }
            String limitPart = " limit " + Integer.toString(limit + 1);
            String sql = String.format(FIND_DIMENSION_VALUES_SQL, this.dbHint, offsetPart, metricNamePart, tenantId, dimensionName, limitPart);
            Query query = h.createQuery(sql);
            if (!Strings.isNullOrEmpty((String)offset)) {
                logger.debug("binding offset: {}", (Object)offset);
                query.bind("offset", offset);
            }
            if (!Strings.isNullOrEmpty((String)metricName)) {
                logger.debug("binding metricName: {}", (Object)metricName);
                query.bind("metricName", metricName);
            }
            List rows = query.list();
            ArrayList<DimensionValue> dimensionValuesList = new ArrayList<DimensionValue>(rows.size());
            for (Map row : rows) {
                String dimensionValue = (String)row.get("dValue");
                DimensionValue dimValue = new DimensionValue(metricName, dimensionName, dimensionValue);
                dimensionValuesList.add(dimValue);
            }
            ArrayList<DimensionValue> arrayList = dimensionValuesList;
            return arrayList;
        }
    }

    @Override
    public List<DimensionName> findNames(String metricName, String tenantId, String offset, int limit) throws Exception {
        String offsetPart = "";
        String metricNamePart = "";
        try (Handle h = this.db.open();){
            if (!Strings.isNullOrEmpty((String)offset)) {
                offsetPart = " and dims.name > :offset";
            }
            if (!Strings.isNullOrEmpty((String)metricName)) {
                metricNamePart = " and def.name = :metricName";
            }
            String limitPart = " limit " + Integer.toString(limit + 1);
            String sql = String.format(FIND_DIMENSION_NAMES_SQL, this.dbHint, offsetPart, metricNamePart, tenantId, limitPart);
            Query query = h.createQuery(sql);
            if (!Strings.isNullOrEmpty((String)offset)) {
                logger.debug("binding offset: {}", (Object)offset);
                query.bind("offset", offset);
            }
            if (!Strings.isNullOrEmpty((String)metricName)) {
                logger.debug("binding metricName: {}", (Object)metricName);
                query.bind("metricName", metricName);
            }
            List rows = query.list();
            ArrayList<DimensionName> dimensionNamesList = new ArrayList<DimensionName>(rows.size());
            for (Map row : rows) {
                String dimensionName = (String)row.get("dName");
                DimensionName dimName = new DimensionName(metricName, dimensionName);
                dimensionNamesList.add(dimName);
            }
            ArrayList<DimensionName> arrayList = dimensionNamesList;
            return arrayList;
        }
    }
}

