/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.infrastructure.persistence.vertica;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import monasca.api.ApiConfig;
import monasca.api.domain.model.metric.MetricDefinitionRepo;
import monasca.api.domain.model.metric.MetricName;
import monasca.api.infrastructure.persistence.vertica.MetricQueries;
import monasca.api.resource.exception.Exceptions;
import monasca.common.model.metric.MetricDefinition;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricDefinitionVerticaRepoImpl
implements MetricDefinitionRepo {
    private static final Logger logger = LoggerFactory.getLogger(MetricDefinitionVerticaRepoImpl.class);
    private static final String METRIC_DEF_SUB_QUERY = "SELECT TO_HEX(defDimsSub.id) FROM MonMetrics.Definitions defSub JOIN MonMetrics.DefinitionDimensions defDimsSub ON defSub.id = defDimsSub.definition_id %s WHERE defSub.tenant_id = :tenantId %s %s %s %s GROUP BY defDimsSub.id ORDER BY defDimsSub.id ASC %s ";
    private static final String FIND_METRIC_NAMES_SQL = "SELECT %s distinct def.name FROM MonMetrics.Definitions def JOIN MonMetrics.DefinitionDimensions defDimsSub ON def.id = defDimsSub.definition_id WHERE def.tenant_id = :tenantId %s %s ORDER BY def.name ASC %s ";
    private static final String TABLE_TO_JOIN_ON = "defDimsSub";
    private final DBI db;
    private final String dbHint;

    @Inject
    public MetricDefinitionVerticaRepoImpl(@Named(value="vertica") DBI db, ApiConfig config) {
        this.db = db;
        this.dbHint = config.vertica.dbHint;
    }

    @Override
    public List<MetricName> findNames(String tenantId, Map<String, String> dimensions, String offset, int limit) throws Exception {
        List<Map<String, Object>> rows = this.executeMetricNamesQuery(tenantId, dimensions, offset, limit);
        ArrayList<MetricName> metricNameList = new ArrayList<MetricName>(rows.size());
        for (Map<String, Object> row : rows) {
            String name = (String)row.get("name");
            MetricName metricName = new MetricName(name);
            metricNameList.add(metricName);
        }
        return metricNameList;
    }

    private List<Map<String, Object>> executeMetricNamesQuery(String tenantId, Map<String, String> dimensions, String offset, int limit) {
        String offsetPart = "";
        if (offset != null && !offset.isEmpty()) {
            offsetPart = " and def.name > '" + offset + "' ";
        }
        String limitPart = " limit " + Integer.toString(limit + 1);
        try (Handle h = this.db.open();){
            String sql = String.format(FIND_METRIC_NAMES_SQL, this.dbHint, offsetPart, MetricQueries.buildDimensionAndClause(dimensions, TABLE_TO_JOIN_ON), limitPart);
            Query query = (Query)h.createQuery(sql).bind("tenantId", tenantId);
            MetricQueries.bindDimensionsToQuery(query, dimensions);
            List list = query.list();
            return list;
        }
    }

    @Override
    public List<MetricDefinition> find(String tenantId, String name, Map<String, String> dimensions, DateTime startTime, DateTime endTime, String offset, int limit) {
        List<Map<String, Object>> rows = this.executeMetricDefsQuery(tenantId, name, dimensions, startTime, endTime, offset, limit);
        ArrayList<MetricDefinition> metricDefs = new ArrayList<MetricDefinition>(rows.size());
        String currentDefDimId = null;
        HashMap<String, String> dims = null;
        for (Map<String, Object> row : rows) {
            String defDimId = (String)row.get("defDimsId");
            String metricName = (String)row.get("name");
            String dimName = (String)row.get("dName");
            String dimValue = (String)row.get("dValue");
            if (defDimId == null || !defDimId.equals(currentDefDimId)) {
                currentDefDimId = defDimId;
                dims = new HashMap<String, String>();
                if (dimName != null && dimValue != null) {
                    dims.put(dimName, dimValue);
                }
                MetricDefinition m = new MetricDefinition(metricName, dims);
                m.setId(defDimId);
                metricDefs.add(m);
                continue;
            }
            dims.put(dimName, dimValue);
        }
        return metricDefs;
    }

    private List<Map<String, Object>> executeMetricDefsQuery(String tenantId, String name, Map<String, String> dimensions, DateTime startTime, DateTime endTime, String offset, int limit) {
        String namePart = "";
        if (name != null && !name.isEmpty()) {
            namePart = " and defSub.name = :name ";
        }
        String offsetPart = "";
        if (offset != null && !offset.isEmpty()) {
            offsetPart = " and defDimsSub.id > :offset ";
        }
        String limitPart = "";
        if (limit > 0) {
            limitPart = "limit " + Integer.toString(limit + 1);
        }
        try (Handle h = this.db.open();){
            String sql = String.format("SELECT %s TO_HEX(defDims.id) as defDimsId, def.name, dims.name as dName, dims.value AS dValue FROM MonMetrics.Definitions def JOIN MonMetrics.DefinitionDimensions defDims ON def.id = defDims.definition_id LEFT OUTER JOIN MonMetrics.Dimensions dims ON dims.dimension_set_id = defDims.dimension_set_id WHERE TO_HEX(defDims.id) in (%s) ORDER BY defDims.id ASC", this.dbHint, String.format(METRIC_DEF_SUB_QUERY, MetricQueries.buildTimeJoin(startTime), namePart, offsetPart, MetricQueries.buildDimensionAndClause(dimensions, TABLE_TO_JOIN_ON), MetricQueries.buildTimeAndClause(startTime, endTime), limitPart));
            Query query = (Query)h.createQuery(sql).bind("tenantId", tenantId);
            if (name != null && !name.isEmpty()) {
                logger.debug("binding name: {}", (Object)name);
                query.bind("name", name);
            }
            if (startTime != null) {
                query.bind("startTime", (Object)startTime);
            }
            if (endTime != null) {
                query.bind("endTime", (Object)endTime);
            }
            if (offset != null && !offset.isEmpty()) {
                logger.debug("binding offset: {}", (Object)offset);
                try {
                    query.bind("offset", Hex.decodeHex((char[])offset.toCharArray()));
                }
                catch (DecoderException e) {
                    throw Exceptions.badRequest("failed to decode offset " + offset, new Object[]{e});
                }
            }
            MetricQueries.bindDimensionsToQuery(query, dimensions);
            List list = query.list();
            return list;
        }
    }
}

