/*
 * Decompiled with CFR 0.152.
 */
package monasca.api.resource;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import monasca.api.app.AlarmService;
import monasca.api.app.command.UpdateAlarmCommand;
import monasca.api.app.validation.MetricNameValidation;
import monasca.api.app.validation.Validation;
import monasca.api.domain.model.alarm.Alarm;
import monasca.api.domain.model.alarm.AlarmCount;
import monasca.api.domain.model.alarm.AlarmRepo;
import monasca.api.domain.model.alarmstatehistory.AlarmStateHistory;
import monasca.api.domain.model.alarmstatehistory.AlarmStateHistoryRepo;
import monasca.api.infrastructure.persistence.PersistUtils;
import monasca.api.resource.Links;
import monasca.api.resource.annotation.PATCH;
import monasca.api.resource.exception.Exceptions;
import monasca.common.model.alarm.AlarmSeverity;
import monasca.common.model.alarm.AlarmState;
import org.hibernate.validator.constraints.NotEmpty;
import org.joda.time.DateTime;

@Path(value="/v2.0/alarms")
public class AlarmResource {
    private final AlarmService service;
    private final AlarmRepo repo;
    private final PersistUtils persistUtils;
    private final AlarmStateHistoryRepo stateHistoryRepo;
    private static final List<String> ALLOWED_GROUP_BY = Arrays.asList("alarm_definition_id", "name", "state", "severity", "link", "lifecycle_state", "metric_name", "dimension_name", "dimension_value");
    private static final List<String> ALLOWED_SORT_BY = Arrays.asList("alarm_id", "alarm_definition_id", "alarm_definition_name", "state", "severity", "lifecycle_state", "link", "state_updated_timestamp", "updated_timestamp", "created_timestamp");

    @Inject
    public AlarmResource(AlarmService service, AlarmRepo repo, AlarmStateHistoryRepo stateHistoryRepo, PersistUtils persistUtils) {
        this.service = service;
        this.repo = repo;
        this.stateHistoryRepo = stateHistoryRepo;
        this.persistUtils = persistUtils;
    }

    @DELETE
    @Timed
    @Path(value="/{alarm_id}")
    public void delete(@HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_id") String alarmId) {
        this.service.delete(tenantId, alarmId);
    }

    @GET
    @Timed
    @Path(value="/{alarm_id}")
    @Produces(value={"application/json"})
    public Alarm get(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_id") String alarm_id) {
        return this.fixAlarmLinks(uriInfo, this.repo.findById(tenantId, alarm_id));
    }

    private Alarm fixAlarmLinks(UriInfo uriInfo, Alarm alarm) {
        Links.hydrate(alarm.getAlarmDefinition(), uriInfo, "/v2.0/alarm-definitions");
        return Links.hydrate(alarm, uriInfo, true, new String[0]);
    }

    @GET
    @Timed
    @Path(value="/{alarm_id}/state-history")
    @Produces(value={"application/json"})
    public Object getStateHistory(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_id") String alarmId, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit) throws Exception {
        int paging_limit = this.persistUtils.getLimit(limit);
        List<AlarmStateHistory> resource = this.stateHistoryRepo.findById(tenantId, alarmId, offset, paging_limit);
        return Links.paginate(paging_limit, resource, uriInfo);
    }

    @GET
    @Timed
    @Path(value="/state-history")
    @Produces(value={"application/json"})
    public Object listStateHistory(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="dimensions") String dimensionsStr, @QueryParam(value="start_time") String startTimeStr, @QueryParam(value="end_time") String endTimeStr, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit) throws Exception {
        DateTime startTime = Validation.parseAndValidateDate(startTimeStr, "start_time", false);
        DateTime endTime = Validation.parseAndValidateDate(endTimeStr, "end_time", false);
        Validation.parseAndValidateDate(offset, "offset", false);
        if (startTime != null) {
            Validation.validateTimes(startTime, endTime);
        }
        Map<String, String> dimensions = Strings.isNullOrEmpty((String)dimensionsStr) ? null : Validation.parseAndValidateDimensions(dimensionsStr);
        int paging_limit = this.persistUtils.getLimit(limit);
        List<AlarmStateHistory> resources = this.stateHistoryRepo.find(tenantId, dimensions, startTime, endTime, offset, paging_limit);
        return Links.paginate(paging_limit, resources, uriInfo);
    }

    @GET
    @Timed
    @Produces(value={"application/json"})
    public Object list(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @QueryParam(value="alarm_definition_id") String alarmDefId, @QueryParam(value="metric_name") String metricName, @QueryParam(value="metric_dimensions") String metricDimensionsStr, @QueryParam(value="state") AlarmState state, @QueryParam(value="severity") String severity, @QueryParam(value="lifecycle_state") String lifecycleState, @QueryParam(value="link") String link, @QueryParam(value="state_updated_start_time") String stateUpdatedStartStr, @QueryParam(value="sort_by") String sortBy, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit) throws Exception {
        Map<String, String> metricDimensions = Strings.isNullOrEmpty((String)metricDimensionsStr) ? null : Validation.parseAndValidateDimensions(metricDimensionsStr);
        MetricNameValidation.validate(metricName, false);
        DateTime stateUpdatedStart = Validation.parseAndValidateDate(stateUpdatedStartStr, "state_updated_start_time", false);
        List<String> sortByList = Validation.parseAndValidateSortBy(sortBy, ALLOWED_SORT_BY);
        if (!Strings.isNullOrEmpty((String)offset)) {
            Validation.parseAndValidateNumber(offset, "offset");
        }
        List<AlarmSeverity> severityList = Validation.parseAndValidateSeverity(severity);
        int paging_limit = this.persistUtils.getLimit(limit);
        List<Alarm> alarms = this.repo.find(tenantId, alarmDefId, metricName, metricDimensions, state, severityList, lifecycleState, link, stateUpdatedStart, sortByList, offset, paging_limit, true);
        for (Alarm alarm : alarms) {
            Links.hydrate(alarm.getAlarmDefinition(), uriInfo, "/v2.0/alarm-definitions");
        }
        return Links.paginateAlarming(paging_limit, Links.hydrate(alarms, uriInfo, new String[0]), uriInfo);
    }

    @PATCH
    @Timed
    @Path(value="/{alarm_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Alarm patch(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_id") String alarmId, @NotEmpty Map<String, String> fields) throws JsonMappingException {
        String stateStr = fields.get("state");
        String lifecycleState = fields.get("lifecycle_state");
        String link = fields.get("link");
        AlarmState state = stateStr == null ? null : Validation.parseAndValidate(AlarmState.class, stateStr);
        Validation.validateLifecycleState(lifecycleState);
        Validation.validateLink(link);
        return this.fixAlarmLinks(uriInfo, this.service.patch(tenantId, alarmId, state, lifecycleState, link));
    }

    @PUT
    @Timed
    @Path(value="/{alarm_id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Alarm update(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_id") String alarmId, @Valid UpdateAlarmCommand command) {
        Validation.validateLifecycleState(command.lifecycleState);
        Validation.validateLink(command.link);
        return this.fixAlarmLinks(uriInfo, this.service.update(tenantId, alarmId, command));
    }

    @GET
    @Timed
    @Path(value="/count")
    @Produces(value={"application/json"})
    public Object getCount(@Context UriInfo uriInfo, @HeaderParam(value="X-Tenant-Id") String tenantId, @PathParam(value="alarm_id") String alarmId, @QueryParam(value="alarm_definition_id") String alarmDefId, @QueryParam(value="metric_name") String metricName, @QueryParam(value="metric_dimensions") String metricDimensionsStr, @QueryParam(value="state") AlarmState state, @QueryParam(value="severity") String severity, @QueryParam(value="lifecycle_state") String lifecycleState, @QueryParam(value="link") String link, @QueryParam(value="state_updated_start_time") String stateUpdatedStartStr, @QueryParam(value="group_by") String groupByStr, @QueryParam(value="offset") String offset, @QueryParam(value="limit") String limit) throws Exception {
        List<String> groupBy;
        Map<String, String> metricDimensions = Strings.isNullOrEmpty((String)metricDimensionsStr) ? null : Validation.parseAndValidateDimensions(metricDimensionsStr);
        MetricNameValidation.validate(metricName, false);
        DateTime stateUpdatedStart = Validation.parseAndValidateDate(stateUpdatedStartStr, "state_updated_start_time", false);
        List<AlarmSeverity> severityList = Validation.parseAndValidateSeverity(severity);
        List<String> list = groupBy = Strings.isNullOrEmpty((String)groupByStr) ? null : this.parseAndValidateGroupBy(groupByStr);
        if (offset != null) {
            Validation.parseAndValidateNumber(offset, "offset");
        }
        int paging_limit = this.persistUtils.getLimit(limit);
        AlarmCount resource = this.repo.getAlarmsCount(tenantId, alarmDefId, metricName, metricDimensions, state, severityList, lifecycleState, link, stateUpdatedStart, groupBy, offset, paging_limit);
        Links.paginateAlarmCount(resource, paging_limit, uriInfo);
        return resource;
    }

    private List<String> parseAndValidateGroupBy(String groupByStr) {
        ArrayList groupBy = null;
        if (!Strings.isNullOrEmpty((String)groupByStr) && !ALLOWED_GROUP_BY.containsAll(groupBy = Lists.newArrayList((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)groupByStr)))) {
            throw Exceptions.unprocessableEntity("Unprocessable Entity", "Invalid group_by field");
        }
        return groupBy;
    }
}

