/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.dropwizard.persistence;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.jdbi.DBIFactory;
import io.dropwizard.setup.Environment;
import org.skife.jdbi.v2.DBI;

public class DatabaseModule
extends AbstractModule {
    private final Environment environment;
    private final DataSourceFactory config;

    public DatabaseModule(Environment environment, DataSourceFactory config) {
        this.environment = environment;
        this.config = config;
    }

    protected void configure() {
        this.bind(DataSourceFactory.class).toInstance((Object)this.config);
        this.bind(DBI.class).toProvider((Provider)new Provider<DBI>(){

            public DBI get() {
                try {
                    return new DBIFactory().build(DatabaseModule.this.environment, DatabaseModule.this.config, "platform");
                }
                catch (ClassNotFoundException e) {
                    throw new ProvisionException("Failed to provision DBI", (Throwable)e);
                }
            }
        }).in(Scopes.SINGLETON);
    }
}

