/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.dropwizard;

import com.google.common.collect.ImmutableMap;
import io.dropwizard.Application;
import io.dropwizard.Configuration;
import io.dropwizard.cli.ServerCommand;
import io.dropwizard.lifecycle.ServerLifecycleListener;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.testing.junit.ConfigOverride;
import java.util.Enumeration;
import java.util.Map;
import net.sourceforge.argparse4j.inf.Namespace;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

@Test
public abstract class AbstractAppTest<C extends Configuration> {
    private final Class<? extends Application<C>> applicationClass;
    private final String configPath;
    private C configuration;
    private Application<C> application;
    private Environment environment;
    private Server jettyServer;

    public AbstractAppTest(Class<? extends Application<C>> applicationClass, String configPath, ConfigOverride ... configOverrides) {
        this.applicationClass = applicationClass;
        this.configPath = configPath;
        for (ConfigOverride configOverride : configOverrides) {
            configOverride.addToSystemProperties();
        }
    }

    @BeforeSuite
    protected void startServer() throws Exception {
        this.startIfRequired();
    }

    @AfterSuite
    protected void stopServer() throws Exception {
        this.resetConfigOverrides();
        this.jettyServer.stop();
    }

    private void resetConfigOverrides() {
        Enumeration<?> props = System.getProperties().propertyNames();
        while (props.hasMoreElements()) {
            String keyString = (String)props.nextElement();
            if (!keyString.startsWith("dw.")) continue;
            System.clearProperty(keyString);
        }
    }

    private void startIfRequired() {
        if (this.jettyServer != null) {
            return;
        }
        try {
            this.application = this.newApplication();
            Bootstrap bootstrap = new Bootstrap<C>(this.application){

                public void run(C configuration, Environment environment) throws Exception {
                    environment.lifecycle().addServerLifecycleListener(new ServerLifecycleListener(){

                        public void serverStarted(Server server) {
                            AbstractAppTest.this.jettyServer = server;
                        }
                    });
                    AbstractAppTest.this.configuration = configuration;
                    AbstractAppTest.this.environment = environment;
                    super.run(configuration, environment);
                }
            };
            this.application.initialize(bootstrap);
            ServerCommand command = new ServerCommand(this.application);
            Namespace namespace = new Namespace((Map)ImmutableMap.of((Object)"file", (Object)this.configPath));
            command.run(bootstrap, namespace);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public C getConfiguration() {
        return this.configuration;
    }

    public int getLocalPort() {
        return ((ServerConnector)this.jettyServer.getConnectors()[0]).getLocalPort();
    }

    public Application<C> newApplication() {
        try {
            return this.applicationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <A extends Application<C>> A getApplication() {
        return (A)this.application;
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

