/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.dropwizard;

import com.beust.jcommander.internal.Maps;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.LowLevelAppDescriptor;
import io.dropwizard.Configuration;
import io.dropwizard.configuration.ConfigurationFactory;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.jersey.DropwizardResourceConfig;
import io.dropwizard.jersey.jackson.JacksonMessageBodyProvider;
import io.dropwizard.logging.LoggingFactory;
import io.dropwizard.setup.Environment;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractResourceTest {
    private final Set<Object> singletons = Sets.newHashSet();
    private final Set<Class<?>> providers = Sets.newHashSet();
    private final Map<String, Boolean> features = Maps.newHashMap();
    private final Map<String, Object> properties = Maps.newHashMap();
    protected final ObjectMapper objectMapper = Jackson.newObjectMapper();
    protected final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    protected final MetricRegistry metricRegistry = new MetricRegistry();
    protected final Environment environment = new Environment("test", this.objectMapper, this.validator, this.metricRegistry, Thread.currentThread().getContextClassLoader());
    private JerseyTest test;

    public void addFeature(String feature, Boolean value) {
        this.features.put(feature, value);
    }

    public void addProperty(String property, Object value) {
        this.properties.put(property, value);
    }

    public void addProviders(Class<?> ... providers) {
        for (Class<?> provider : providers) {
            this.providers.add(provider);
        }
    }

    public void addResources(Object ... resources) {
        for (Object resource : resources) {
            this.singletons.add(resource);
        }
    }

    public void addSingletons(Object ... providers) {
        for (Object provider : providers) {
            this.singletons.add(provider);
        }
    }

    public Client client() {
        return this.test.client();
    }

    public JerseyTest getJerseyTest() {
        return this.test;
    }

    @AfterMethod
    protected void afterTestCase() throws Exception {
        if (this.test != null) {
            this.test.tearDown();
        }
    }

    @BeforeMethod
    protected void beforeTestCase() throws Exception {
        this.singletons.clear();
        this.providers.clear();
        this.features.clear();
        this.properties.clear();
        this.setupResources();
        this.test = new JerseyTest(){

            protected AppDescriptor configure() {
                DropwizardResourceConfig config = DropwizardResourceConfig.forTesting((MetricRegistry)AbstractResourceTest.this.metricRegistry);
                for (Class clazz : AbstractResourceTest.this.providers) {
                    config.getClasses().add(clazz);
                }
                for (Map.Entry entry : AbstractResourceTest.this.features.entrySet()) {
                    config.getFeatures().put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry entry : AbstractResourceTest.this.properties.entrySet()) {
                    config.getProperties().put(entry.getKey(), entry.getValue());
                }
                config.getSingletons().add(new JacksonMessageBodyProvider(AbstractResourceTest.this.objectMapper, AbstractResourceTest.this.validator));
                config.getSingletons().addAll(AbstractResourceTest.this.singletons);
                return new LowLevelAppDescriptor.Builder((ResourceConfig)config).build();
            }
        };
        this.test.setUp();
    }

    protected <T extends Configuration> T getConfiguration(String filename, Class<T> configurationClass) throws Exception {
        ConfigurationFactory configurationFactory = new ConfigurationFactory(configurationClass, this.validator, this.objectMapper, "dw");
        if (filename != null) {
            File file = new File(Resources.getResource((String)filename).getFile());
            if (!file.exists()) {
                throw new FileNotFoundException("File " + file + " not found");
            }
            return (T)((Configuration)configurationFactory.build(file));
        }
        return (T)((Configuration)configurationFactory.build());
    }

    protected abstract void setupResources() throws Exception;

    static {
        LoggingFactory.bootstrap();
    }
}

