/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.hibernate.db;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import monasca.common.hibernate.db.AbstractAuditablePersistable;
import monasca.common.hibernate.db.AlarmDefinitionDb;
import monasca.common.hibernate.db.AlarmMetricDb;
import monasca.common.hibernate.db.SubAlarmDb;
import monasca.common.model.alarm.AlarmState;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.joda.time.DateTime;

@Entity
@Table(name="alarm")
@NamedQueries(value={@NamedQuery(name="Alarm.deleteByAlarmDefinitionId", query="delete from AlarmDb a where a.alarmDefinition.id = :alarmDefinitionId"), @NamedQuery(name="Alarm.deleteById", query="delete from AlarmDb a where a.id = :id"), @NamedQuery(name="Alarm.findById", query="from AlarmDb a where a.id = :id")})
public class AlarmDb
extends AbstractAuditablePersistable<String> {
    private static final long serialVersionUID = -9084263584287898881L;
    @JoinColumn(name="alarm_definition_id", nullable=false)
    @ManyToOne(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, optional=false)
    private AlarmDefinitionDb alarmDefinition;
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private AlarmState state;
    @Column(name="lifecycle_state", length=50)
    private String lifecycleState;
    @Column(name="link", length=512)
    private String link;
    @Column(name="state_updated_at")
    private Date stateUpdatedAt;
    @OneToMany(mappedBy="alarmMetricId.alarm", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.REMOVE})
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Collection<AlarmMetricDb> alarmMetrics;
    @OneToMany(mappedBy="alarm", fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.REMOVE})
    @OnDelete(action=OnDeleteAction.CASCADE)
    private Collection<SubAlarmDb> subAlarms;

    public AlarmDb() {
    }

    public AlarmDb(String id, AlarmDefinitionDb alarmDefinition, AlarmState state, String lifecycleState, String link, DateTime stateUpdatedAt, DateTime created_at, DateTime updated_at) {
        super(id, created_at, updated_at);
        this.setAlarmDefinition(alarmDefinition);
        this.link = link;
        this.state = state;
        this.lifecycleState = lifecycleState;
        this.setStateUpdatedAt(stateUpdatedAt);
    }

    public AlarmState getState() {
        return this.state;
    }

    public AlarmDb setState(AlarmState state) {
        this.state = state;
        return this;
    }

    public String getLifecycleState() {
        return this.lifecycleState;
    }

    public AlarmDb setLifecycleState(String lifecycleState) {
        this.lifecycleState = lifecycleState;
        return this;
    }

    public String getLink() {
        return this.link;
    }

    public AlarmDb setLink(String link) {
        this.link = link;
        return this;
    }

    public DateTime getStateUpdatedAt() {
        return AlarmDb.nullSafeGetDate(this.stateUpdatedAt);
    }

    public AlarmDb setStateUpdatedAt(DateTime stateUpdatedAt) {
        this.stateUpdatedAt = AlarmDb.nullSafeSetDate(stateUpdatedAt);
        return this;
    }

    public AlarmDefinitionDb getAlarmDefinition() {
        return this.alarmDefinition;
    }

    public AlarmDb setAlarmDefinition(AlarmDefinitionDb alarmDefinition) {
        if (!alarmDefinition.hasAlarm(this)) {
            alarmDefinition.addAlarm(this);
        }
        this.alarmDefinition = alarmDefinition;
        return this;
    }

    public Collection<AlarmMetricDb> getAlarmMetrics() {
        return this.alarmMetrics != null ? this.alarmMetrics : (this.alarmMetrics = Sets.newHashSet());
    }

    public AlarmDb setAlarmMetrics(Collection<AlarmMetricDb> alarmMetrics) {
        if (alarmMetrics == null || alarmMetrics.isEmpty()) {
            return this;
        }
        final AlarmDb self = this;
        this.alarmMetrics = Sets.newHashSetWithExpectedSize((int)alarmMetrics.size());
        FluentIterable.from(alarmMetrics).transform((Function)new Function<AlarmMetricDb, AlarmMetricDb>(){

            @Nullable
            public AlarmMetricDb apply(@Nullable AlarmMetricDb input) {
                assert (input != null);
                input.setAlarm(self);
                return input;
            }
        }).copyInto(this.alarmMetrics);
        return this;
    }

    public AlarmDb addAlarmMetric(AlarmMetricDb alarmMetric) {
        if (alarmMetric == null || this.hasAlarmMetric(alarmMetric)) {
            return this;
        }
        this.getAlarmMetrics().add(alarmMetric);
        alarmMetric.setAlarm(this);
        return this;
    }

    public AlarmDb removeAlarmMetric(AlarmMetricDb alarmDb) {
        if (alarmDb == null || this.alarmMetrics == null) {
            return this;
        }
        this.alarmMetrics.remove(alarmDb);
        return this;
    }

    public boolean hasAlarmMetric(AlarmMetricDb alarm) {
        return alarm != null && this.alarmMetrics != null && this.alarmMetrics.contains(alarm);
    }

    public Collection<SubAlarmDb> getSubAlarms() {
        return this.subAlarms != null ? this.subAlarms : (this.subAlarms = Sets.newHashSet());
    }

    public AlarmDb setSubAlarms(Collection<SubAlarmDb> subAlarms) {
        if (subAlarms == null || subAlarms.isEmpty()) {
            return this;
        }
        final AlarmDb self = this;
        this.subAlarms = Sets.newHashSetWithExpectedSize((int)subAlarms.size());
        FluentIterable.from(subAlarms).transform((Function)new Function<SubAlarmDb, SubAlarmDb>(){

            @Nullable
            public SubAlarmDb apply(@Nullable SubAlarmDb input) {
                assert (input != null);
                input.setAlarm(self);
                return input;
            }
        }).copyInto(this.subAlarms);
        return this;
    }

    public AlarmDb addSubAlarm(SubAlarmDb subAlarm) {
        if (subAlarm == null || this.hasSubAlarm(subAlarm)) {
            return this;
        }
        this.getSubAlarms().add(subAlarm);
        subAlarm.setAlarm(this);
        return this;
    }

    public AlarmDb removeSubAlarm(SubAlarmDb subAlarm) {
        if (subAlarm == null || this.subAlarms == null) {
            return this;
        }
        this.subAlarms.remove(subAlarm);
        return this;
    }

    public boolean hasSubAlarm(SubAlarmDb subAlarm) {
        return subAlarm != null && this.subAlarms != null && this.subAlarms.contains(subAlarm);
    }

    public static interface Queries {
        public static final String DELETE_BY_ALARMDEFINITION_ID = "Alarm.deleteByAlarmDefinitionId";
        public static final String DELETE_BY_ID = "Alarm.deleteById";
        public static final String FIND_BY_ID = "Alarm.findById";
    }
}

