/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.hibernate.db;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.annotation.Nullable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import monasca.common.hibernate.db.AbstractAuditablePersistable;
import monasca.common.hibernate.db.AlarmDb;
import monasca.common.model.alarm.AlarmSeverity;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="alarm_definition", indexes={@Index(name="tenant_id", columnList="tenant_id"), @Index(name="deleted_at", columnList="deleted_at")})
@NamedQueries(value={@NamedQuery(name="AlarmDefinition.byTenantAndIdNotDeleted", query="from AlarmDefinitionDb ad where ad.tenantId = :tenant_id and ad.id = :id and ad.deletedAt is NULL group by ad.id"), @NamedQuery(name="AlarmDefinition.byTenantIdAndId", query="from AlarmDefinitionDb alarm_definition where alarm_definition.tenantId=:tenantId and alarm_definition.id= :id")})
public class AlarmDefinitionDb
extends AbstractAuditablePersistable<String> {
    private static final long serialVersionUID = 2566210444329934008L;
    private static final String DEFAULT_MATCH_BY = "";
    private static final String DEFAULT_NAME = "";
    private static final boolean DEFAULT_ACTIONS_ENABLED = true;
    @Column(name="tenant_id", length=36, nullable=false)
    private String tenantId;
    @Column(name="name", length=255, nullable=false)
    private String name = "";
    @Column(name="description", length=255)
    private String description;
    @Lob
    @Type(type="text")
    @Basic(fetch=FetchType.LAZY)
    @Column(name="expression", nullable=false, length=0xFFFFFF)
    private String expression;
    @Column(name="severity", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AlarmSeverity severity;
    @Column(name="match_by", length=255)
    private String matchBy = "";
    @Column(name="actions_enabled", length=1, nullable=false)
    private boolean actionsEnabled = true;
    @Column(name="deleted_at")
    private Date deletedAt;
    @BatchSize(size=50)
    @OneToMany(mappedBy="alarmDefinition", fetch=FetchType.LAZY)
    private Collection<AlarmDb> alarms;

    public AlarmDefinitionDb() {
    }

    public AlarmDefinitionDb(String id, String tenantId, String name, String description, String expression, AlarmSeverity severity, String matchBy, boolean actionsEnabled, DateTime created_at, DateTime updated_at, DateTime deletedAt) {
        super(id, created_at, updated_at);
        this.id = id;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.expression = expression;
        this.severity = severity;
        this.matchBy = matchBy;
        this.actionsEnabled = actionsEnabled;
        this.setDeletedAt(deletedAt);
    }

    public AlarmDefinitionDb(String id, String tenantId, String expression, AlarmSeverity severity, DateTime created_at, DateTime updated_at) {
        this(id, tenantId, null, null, expression, severity, "", true, created_at, updated_at, null);
    }

    public AlarmDefinitionDb setDeletedAt(DateTime deletedAt) {
        this.deletedAt = AlarmDefinitionDb.nullSafeSetDate(deletedAt);
        return this;
    }

    public AlarmDefinitionDb setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public AlarmDefinitionDb setName(String name) {
        this.name = name;
        return this;
    }

    public AlarmDefinitionDb setDescription(String description) {
        this.description = description;
        return this;
    }

    public AlarmDefinitionDb setExpression(String expression) {
        this.expression = expression;
        return this;
    }

    public AlarmDefinitionDb setSeverity(AlarmSeverity severity) {
        this.severity = severity;
        return this;
    }

    public AlarmDefinitionDb setMatchBy(String matchBy) {
        this.matchBy = matchBy;
        return this;
    }

    public AlarmDefinitionDb setActionsEnabled(boolean actionsEnabled) {
        this.actionsEnabled = actionsEnabled;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExpression() {
        return this.expression;
    }

    public AlarmSeverity getSeverity() {
        return this.severity;
    }

    public String getMatchBy() {
        return this.matchBy;
    }

    public Collection<String> getMatchByAsCollection() {
        if (this.matchBy == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])this.matchBy.split(","));
    }

    public boolean isActionsEnabled() {
        return this.actionsEnabled;
    }

    public DateTime getDeletedAt() {
        return AlarmDefinitionDb.nullSafeGetDate(this.deletedAt);
    }

    public boolean hasAlarm(AlarmDb alarm) {
        return alarm != null && this.alarms != null && this.alarms.contains(alarm);
    }

    public Collection<AlarmDb> getAlarms() {
        return this.alarms != null ? this.alarms : (this.alarms = Sets.newHashSet());
    }

    public AlarmDefinitionDb setAlarms(Collection<AlarmDb> alarms) {
        final AlarmDefinitionDb self = this;
        this.alarms = Sets.newHashSetWithExpectedSize((int)alarms.size());
        FluentIterable.from(alarms).transform((Function)new Function<AlarmDb, AlarmDb>(){

            @Nullable
            public AlarmDb apply(@Nullable AlarmDb input) {
                assert (input != null);
                input.setAlarmDefinition(self);
                return input;
            }
        }).copyInto(this.alarms);
        return this;
    }

    public AlarmDefinitionDb addAlarm(AlarmDb alarmDb) {
        if (alarmDb == null || this.hasAlarm(alarmDb)) {
            return this;
        }
        this.getAlarms().add(alarmDb);
        alarmDb.setAlarmDefinition(this);
        return this;
    }

    public AlarmDefinitionDb removeAlarm(AlarmDb alarmDb) {
        if (alarmDb == null || this.alarms == null) {
            return this;
        }
        this.getAlarms().remove(alarmDb);
        return this;
    }

    public static interface Queries {
        public static final String FIND_BY_TENANT_AND_ID_NOT_DELETED = "AlarmDefinition.byTenantAndIdNotDeleted";
        public static final String FIND_BY_TENANT_ID_AND_ID = "AlarmDefinition.byTenantIdAndId";
    }
}

