/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.hibernate.db;

import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import monasca.common.hibernate.db.AbstractAuditablePersistable;
import monasca.common.hibernate.db.AlarmDb;
import monasca.common.hibernate.db.SubAlarmDefinitionDb;
import monasca.common.model.alarm.AlarmState;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;

@Entity
@Table(name="sub_alarm")
@NamedQueries(value={@NamedQuery(name="SubAlarm.byAlarmDefinitionId", query="select sa from SubAlarmDb as sa, AlarmDb as a where sa.alarm.id=a.id and a.alarmDefinition.id = :id"), @NamedQuery(name="SubAlarm.byAlarmId", query="from SubAlarmDb where alarm_id = :id"), @NamedQuery(name="SubAlarm.updateExpressionBySubexpressionId", query="update SubAlarmDb set expression=:expression where subExpression.id=:alarmSubExpressionId")})
public class SubAlarmDb
extends AbstractAuditablePersistable<String> {
    private static final long serialVersionUID = 5719744905744636511L;
    private static final String DEFAULT_EXPRESSION = "";
    @JoinColumn(name="alarm_id", nullable=false)
    @ManyToOne(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY, optional=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private AlarmDb alarm;
    @JoinColumn(name="sub_expression_id")
    @ManyToOne(cascade={CascadeType.REMOVE}, fetch=FetchType.LAZY)
    private SubAlarmDefinitionDb subExpression;
    @Lob
    @Type(type="text")
    @Basic(fetch=FetchType.LAZY)
    @Column(name="expression", nullable=false, length=0xFFFFFF)
    private String expression = "";
    @Column(name="state")
    @Enumerated(value=EnumType.STRING)
    private AlarmState state;

    public SubAlarmDb() {
    }

    public SubAlarmDb(String id, AlarmDb alarm, String expression, DateTime created_at, DateTime updated_at) {
        this(id, alarm, null, expression, AlarmState.OK, created_at, updated_at);
    }

    public SubAlarmDb(String id, AlarmDb alarm, String expression, AlarmState state, DateTime created_at, DateTime updated_at) {
        this(id, alarm, null, expression, state, created_at, updated_at);
    }

    public SubAlarmDb(String id, AlarmDb alarm, SubAlarmDefinitionDb subExpression, String expression, DateTime created_at, DateTime updated_at) {
        this(id, alarm, subExpression, expression, AlarmState.OK, created_at, updated_at);
    }

    public SubAlarmDb(String id, AlarmDb alarm, SubAlarmDefinitionDb subExpression, String expression, AlarmState state, DateTime created_at, DateTime updated_at) {
        super(id, created_at, updated_at);
        this.alarm = alarm;
        this.subExpression = subExpression;
        this.expression = expression;
        this.state = state;
    }

    public SubAlarmDb setExpression(String expression) {
        this.expression = expression;
        return this;
    }

    public SubAlarmDb setSubExpression(SubAlarmDefinitionDb subExpression) {
        this.subExpression = subExpression;
        return this;
    }

    public SubAlarmDb setAlarm(AlarmDb alarm) {
        if (alarm != null) {
            if (!alarm.hasSubAlarm(this)) {
                alarm.addSubAlarm(this);
            }
            this.alarm = alarm;
        }
        return this;
    }

    public AlarmDb getAlarm() {
        return this.alarm;
    }

    public SubAlarmDefinitionDb getSubExpression() {
        return this.subExpression;
    }

    public String getExpression() {
        return this.expression;
    }

    public AlarmState getState() {
        return this.state;
    }

    public SubAlarmDb setState(AlarmState state) {
        this.state = state;
        return this;
    }

    public static interface Queries {
        public static final String BY_ALARMDEFINITION_ID = "SubAlarm.byAlarmDefinitionId";
        public static final String BY_ALARM_ID = "SubAlarm.byAlarmId";
        public static final String UPDATE_EXPRESSION_BY_SUBEXPRESSION_ID = "SubAlarm.updateExpressionBySubexpressionId";
    }
}

