/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.hibernate.type;

import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nonnull;

public class BinaryId
implements Serializable,
Comparable<BinaryId> {
    private static final long serialVersionUID = -4185721060467793903L;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private final byte[] bytes;
    private transient String hexBytes = null;

    public BinaryId(byte[] bytes) {
        this.bytes = bytes;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String toHexString() {
        return this.convertToHex();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryId)) {
            return false;
        }
        BinaryId binaryId = (BinaryId)o;
        return Arrays.equals(this.bytes, binaryId.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        return this.convertToHex();
    }

    private String convertToHex() {
        if (this.hexBytes == null) {
            this.hexBytes = BinaryId.bytesToHex(this.bytes);
        }
        return this.hexBytes;
    }

    @Override
    public int compareTo(@Nonnull BinaryId binaryId) {
        return ComparisonChain.start().compare((Comparable)((Object)this.toString()), (Comparable)((Object)binaryId.toString())).result();
    }
}

