/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import monasca.common.hibernate.type.BinaryId;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.UserType;

public class BinaryIdType
implements UserType {
    private static final int[] SQL_TYPES = new int[]{-2};

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Class returnedClass() {
        return BinaryId.class;
    }

    public boolean isMutable() {
        return true;
    }

    public Object deepCopy(Object value) throws HibernateException {
        BinaryId binaryId = (BinaryId)value;
        byte[] bytes = binaryId.getBytes();
        if (bytes != null) {
            return new BinaryId(Arrays.copyOf(bytes, bytes.length));
        }
        return value;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        byte[] bytes = rs.getBytes(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        return new BinaryId(bytes);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, -3);
        } else {
            st.setBytes(index, ((BinaryId)value).getBytes());
        }
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return Objects.deepEquals(x, y);
    }

    public int hashCode(Object x) throws HibernateException {
        return Objects.hashCode(x);
    }
}

