/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.hibernate.db;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import monasca.common.hibernate.core.AuditablePersistable;
import monasca.common.hibernate.db.AbstractPersistable;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@DynamicInsert
@DynamicUpdate
@MappedSuperclass
abstract class AbstractAuditablePersistable<T extends Serializable>
extends AbstractPersistable<T>
implements AuditablePersistable<T> {
    private static final long serialVersionUID = 2335373173379564615L;
    @Column(name="created_at", nullable=false)
    private Date createdAt;
    @Version
    @Column(name="updated_at", nullable=false)
    private Date updatedAt;

    AbstractAuditablePersistable() {
        this(null, null, null);
    }

    AbstractAuditablePersistable(T id) {
        this(id, null, null);
    }

    AbstractAuditablePersistable(T id, DateTime createdAt, DateTime updatedAt) {
        super(id);
        this.setDates(createdAt, updatedAt);
    }

    static Date nullSafeSetDate(@Nullable DateTime value) {
        if (value == null) {
            return null;
        }
        return value.toDateTime(DateTimeZone.UTC).toDate();
    }

    static DateTime nullSafeGetDate(@Nullable Date value) {
        if (value == null) {
            return null;
        }
        return new DateTime(value.getTime(), DateTimeZone.UTC);
    }

    @Override
    public DateTime getCreatedAt() {
        return AbstractAuditablePersistable.nullSafeGetDate(this.createdAt);
    }

    @Override
    public AuditablePersistable<T> setCreatedAt(DateTime createdAt) {
        this.createdAt = AbstractAuditablePersistable.nullSafeSetDate(createdAt);
        return this;
    }

    @Override
    public DateTime getUpdatedAt() {
        return AbstractAuditablePersistable.nullSafeGetDate(this.updatedAt);
    }

    @Override
    public AuditablePersistable<T> setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = AbstractAuditablePersistable.nullSafeSetDate(updatedAt);
        return this;
    }

    private void setDates(DateTime createdAt, DateTime updatedAt) {
        Date date = DateTime.now((DateTimeZone)DateTimeZone.UTC).toDate();
        this.createdAt = createdAt == null ? date : createdAt.toDateTime(DateTimeZone.UTC).toDate();
        this.updatedAt = updatedAt == null ? date : updatedAt.toDateTime(DateTimeZone.UTC).toDate();
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("createdAt", (Object)this.createdAt).add("updatedAt", (Object)this.updatedAt).toString();
    }
}

