/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.hibernate.db;

import com.google.common.base.Objects;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import monasca.common.hibernate.core.Persistable;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@DynamicInsert
@DynamicUpdate
@MappedSuperclass
abstract class AbstractPersistable<T extends Serializable>
implements Persistable<T> {
    private static final long serialVersionUID = -4841075518435739989L;
    @Id
    @Column(name="id", length=36)
    protected T id;

    AbstractPersistable() {
    }

    AbstractPersistable(T id) {
        this();
        this.id = id;
    }

    @Override
    public T getId() {
        return this.id;
    }

    @Override
    public Persistable<T> setId(T id) {
        this.id = id;
        return this;
    }

    @Override
    public boolean isNew() {
        return this.id == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPersistable that = (AbstractPersistable)o;
        return Objects.equal(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.id).toString();
    }
}

