/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.hibernate.db;

import com.google.common.base.Objects;
import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import monasca.common.hibernate.db.AlarmDb;
import monasca.common.hibernate.db.AlarmMetricId;
import monasca.common.hibernate.db.MetricDefinitionDimensionsDb;

@Entity
@Table(name="alarm_metric", indexes={@Index(name="metric_definition_dimensions_id", columnList="metric_definition_dimensions_id"), @Index(name="alarm_id", columnList="alarm_id")})
public class AlarmMetricDb
implements Serializable {
    private static final long serialVersionUID = 2852204906043180958L;
    @EmbeddedId
    private AlarmMetricId alarmMetricId;

    public AlarmMetricDb() {
    }

    public AlarmMetricDb(AlarmMetricId alarmMetricId) {
        this();
        this.alarmMetricId = alarmMetricId;
        this.alarmMetricId.getAlarm().addAlarmMetric(this);
    }

    public AlarmMetricDb(AlarmDb alarm, MetricDefinitionDimensionsDb mdd) {
        this(new AlarmMetricId(alarm, mdd));
    }

    public AlarmMetricId getAlarmMetricId() {
        return this.alarmMetricId;
    }

    public AlarmMetricDb setAlarmMetricId(AlarmMetricId alarmMetricId) {
        this.alarmMetricId = alarmMetricId;
        return this;
    }

    public AlarmMetricDb setAlarm(AlarmDb alarm) {
        if (alarm != null) {
            if (!alarm.hasAlarmMetric(this)) {
                alarm.addAlarmMetric(this);
            }
            this.requireAlarmMetricId().setAlarm(alarm);
        }
        return this;
    }

    public AlarmMetricDb setMetricDefinitionDimensionsId(MetricDefinitionDimensionsDb mdd) {
        this.requireAlarmMetricId().setMetricDefinitionDimensions(mdd);
        return this;
    }

    private AlarmMetricId requireAlarmMetricId() {
        if (this.alarmMetricId == null) {
            this.alarmMetricId = new AlarmMetricId();
        }
        return this.alarmMetricId;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("alarmMetricId", (Object)this.alarmMetricId).toString();
    }
}

