/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.hibernate.db;

import com.google.common.base.Objects;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import monasca.common.hibernate.db.MetricDimensionDbId;
import monasca.common.hibernate.type.BinaryId;

@Entity
@Table(name="metric_dimension", indexes={@Index(name="dimension_set_id", columnList="dimension_set_id")}, uniqueConstraints={@UniqueConstraint(name="metric_dimension_key", columnNames={"dimension_set_id", "name"})})
public class MetricDimensionDb
implements Serializable {
    private static final long serialVersionUID = 4261654453776857159L;
    @EmbeddedId
    private MetricDimensionDbId id;
    @Column(name="value", length=255, nullable=false)
    private String value;

    public MetricDimensionDb() {
    }

    public MetricDimensionDb(byte[] dimensionSetId, String name) {
        this(dimensionSetId, name, null);
    }

    public MetricDimensionDb(byte[] dimensionSetId, String name, String value) {
        this(new BinaryId(dimensionSetId), name, value);
    }

    public MetricDimensionDb(BinaryId dimensionSetId, String name, String value) {
        this(new MetricDimensionDbId(dimensionSetId, name), value);
    }

    public MetricDimensionDb(MetricDimensionDbId id, String value) {
        this.id = id;
        this.value = value;
    }

    public MetricDimensionDb setId(MetricDimensionDbId id) {
        this.id = id;
        return this;
    }

    public MetricDimensionDbId getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public MetricDimensionDb setValue(String value) {
        this.value = value;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDimensionDb that = (MetricDimensionDb)o;
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("value", (Object)this.value).toString();
    }
}

