/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.hibernate.db;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import monasca.common.hibernate.db.AbstractAuditablePersistable;
import monasca.common.hibernate.db.AlarmDefinitionDb;
import monasca.common.model.alarm.AlarmOperator;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.joda.time.DateTime;

@Entity
@Table(name="sub_alarm_definition")
@NamedQueries(value={@NamedQuery(name="SubAlarmDefinition.byAlarmDefinitionId", query="from SubAlarmDefinitionDb sad where sad.alarmDefinition.id = :id order by sad.id"), @NamedQuery(name="SubAlarmDefinition.byAlarmDefinitionDimension.subExpressionId", query="SELECT sadd from SubAlarmDefinitionDb sad, SubAlarmDefinitionDimensionDb sadd where sadd.subAlarmDefinitionDimensionId.subExpression.id = sad.id AND sad.alarmDefinition.id = :id"), @NamedQuery(name="SubAlarmDefinition.deleteByIds", query="delete SubAlarmDefinitionDb where id in :ids")})
public class SubAlarmDefinitionDb
extends AbstractAuditablePersistable<String> {
    private static final long serialVersionUID = 8898225134690206198L;
    @JoinColumn(name="alarm_definition_id", nullable=false)
    @ManyToOne(cascade={CascadeType.REMOVE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.LAZY, optional=false)
    @OnDelete(action=OnDeleteAction.CASCADE)
    private AlarmDefinitionDb alarmDefinition;
    @Column(name="function", length=10, nullable=false)
    private String function;
    @Column(name="metric_name", length=100)
    private String metricName;
    @Column(name="operator", length=5, nullable=false)
    private String operator;
    @Column(name="threshold", nullable=false)
    private Double threshold;
    @Column(name="period", length=11, nullable=false)
    private Integer period;
    @Column(name="periods", length=11, nullable=false)
    private Integer periods;
    @Column(name="is_deterministic", length=1, nullable=false)
    private boolean deterministic = false;

    public SubAlarmDefinitionDb() {
    }

    public SubAlarmDefinitionDb(String id, AlarmDefinitionDb alarmDefinition, String function, String metricName, String operator, Double threshold, Integer period, Integer periods, DateTime created_at, DateTime updated_at) {
        this(id, alarmDefinition, function, metricName, operator, threshold, period, periods, created_at, updated_at, false);
    }

    public SubAlarmDefinitionDb(String id, AlarmDefinitionDb alarmDefinition, String function, String metricName, String operator, Double threshold, Integer period, Integer periods, DateTime created_at, DateTime updated_at, boolean deterministic) {
        super(id, created_at, updated_at);
        this.alarmDefinition = alarmDefinition;
        this.function = function;
        this.metricName = metricName;
        this.operator = operator;
        this.threshold = threshold;
        this.period = period;
        this.periods = periods;
        this.deterministic = deterministic;
    }

    public SubAlarmDefinitionDb setPeriods(Integer periods) {
        this.periods = periods;
        return this;
    }

    public SubAlarmDefinitionDb setPeriod(Integer period) {
        this.period = period;
        return this;
    }

    public SubAlarmDefinitionDb setThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public SubAlarmDefinitionDb setOperator(String operator) {
        this.operator = operator;
        return this;
    }

    public SubAlarmDefinitionDb setOperator(AlarmOperator operator) {
        return this.setOperator(operator.name().toUpperCase());
    }

    public SubAlarmDefinitionDb setMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    public SubAlarmDefinitionDb setFunction(String function) {
        this.function = function;
        return this;
    }

    public SubAlarmDefinitionDb setAlarmDefinition(AlarmDefinitionDb alarmDefinition) {
        this.alarmDefinition = alarmDefinition;
        return this;
    }

    public AlarmDefinitionDb getAlarmDefinition() {
        return this.alarmDefinition;
    }

    public String getFunction() {
        return this.function;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getOperator() {
        return this.operator;
    }

    public Double getThreshold() {
        return this.threshold;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public Integer getPeriods() {
        return this.periods;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public SubAlarmDefinitionDb setDeterministic(boolean isDeterministic) {
        this.deterministic = isDeterministic;
        return this;
    }

    public static interface Queries {
        public static final String BY_ALARMDEFINITION_ID = "SubAlarmDefinition.byAlarmDefinitionId";
        public static final String BY_ALARMDEFINITIONDIMENSION_SUBEXPRESSION_ID = "SubAlarmDefinition.byAlarmDefinitionDimension.subExpressionId";
        public static final String DELETE_BY_IDS = "SubAlarmDefinition.deleteByIds";
    }
}

