/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.hibernate.db;

import com.google.common.base.Objects;
import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import monasca.common.hibernate.db.AlarmActionId;
import monasca.common.hibernate.db.AlarmDefinitionDb;
import monasca.common.model.alarm.AlarmState;

@Entity
@Table(name="alarm_action")
@NamedQueries(value={@NamedQuery(name="AlarmAction.deleteByAlarmDefinitionId", query="delete AlarmActionDb aa where aa.alarmActionId.alarmDefinition.id = :id"), @NamedQuery(name="AlarmAction.deleteByAlarmDefinitionIdAndAlarmState", query="delete AlarmActionDb aa where aa.alarmActionId.alarmDefinition.id = :id and aa.alarmActionId.alarmState = :alarmState"), @NamedQuery(name="AlarmAction.findByTenantIdAndAlarmDefinitionId.Distinct", query="select distinct aa from AlarmActionDb aa, AlarmDefinitionDb ad where ad.id=aa.alarmActionId.alarmDefinition.id and ad.deletedAt is null and ad.tenantId= :tenantId and ad.id= :alarmDefId")})
public class AlarmActionDb
implements Serializable {
    private static final long serialVersionUID = -8138171887172601911L;
    @EmbeddedId
    private AlarmActionId alarmActionId;

    public AlarmActionDb() {
        this(null, AlarmState.UNDETERMINED, null);
    }

    public AlarmActionDb(AlarmDefinitionDb alarmDefinition, AlarmState alarmState, String actionId) {
        this.alarmActionId = new AlarmActionId(alarmDefinition, alarmState, actionId);
    }

    public AlarmActionId getAlarmActionId() {
        return this.alarmActionId;
    }

    public AlarmActionDb setAlarmActionId(AlarmActionId alarmActionId) {
        this.alarmActionId = alarmActionId;
        return this;
    }

    public boolean isInAlarmState(AlarmState state) {
        return this.alarmActionId != null && this.alarmActionId.getAlarmState().equals((Object)state);
    }

    public AlarmActionDb setAlarmState(AlarmState alarmState) {
        this.requireAlarmActionId().setAlarmState(alarmState);
        return this;
    }

    public AlarmActionDb setActionId(String actionId) {
        this.requireAlarmActionId().setActionId(actionId);
        return this;
    }

    public AlarmActionDb setAlarmDefinition(AlarmDefinitionDb alarmDefinition) {
        this.requireAlarmActionId().setAlarmDefinition(alarmDefinition);
        return this;
    }

    public AlarmState getAlarmState() {
        return this.requireAlarmActionId().getAlarmState();
    }

    public AlarmDefinitionDb getAlarmDefinition() {
        return this.requireAlarmActionId().getAlarmDefinition();
    }

    public String getActionId() {
        return this.requireAlarmActionId().getActionId();
    }

    private AlarmActionId requireAlarmActionId() {
        if (this.alarmActionId == null) {
            this.alarmActionId = new AlarmActionId();
        }
        return this.alarmActionId;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("alarmActionId", (Object)this.alarmActionId).toString();
    }

    public static interface Queries {
        public static final String DELETE_BY_ALARMDEFINITION_ID = "AlarmAction.deleteByAlarmDefinitionId";
        public static final String DELETE_BY_ALARMDEFINITION_ID_AND_ALARMSTATE = "AlarmAction.deleteByAlarmDefinitionIdAndAlarmState";
        public static final String FIND_BY_TENANT_ID_AND_ALARMDEFINITION_ID_DISTINCT = "AlarmAction.findByTenantIdAndAlarmDefinitionId.Distinct";
    }
}

