/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.middleware;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import monasca.common.middleware.AdminAuthException;
import monasca.common.middleware.AuthClient;
import monasca.common.middleware.AuthException;
import monasca.common.middleware.Config;
import monasca.common.middleware.ServiceUnavailableException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAuthClient
implements AuthClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpAuthClient.class);
    private static final int DELTA_TIME_IN_SEC = 30;
    private static SimpleDateFormat expiryFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Config appConfig = Config.getInstance();
    private HttpClient client;
    private String adminToken;
    private String adminTokenExpiry;
    private URI uri;

    public HttpAuthClient(HttpClient client, URI uri) {
        this.client = client;
        this.uri = uri;
    }

    @Override
    public String validateTokenForServiceEndpointV3(String token) throws ClientProtocolException {
        String newUri = this.uri.toString() + "/v3/auth/tokens/";
        Header[] header = new Header[]{new BasicHeader("X-Subject-Token", token)};
        return this.verifyUUIDToken(token, newUri, header);
    }

    private String verifyUUIDToken(String token, String newUri, Header[] header) throws ClientProtocolException {
        HttpResponse response = this.sendGet(newUri, header);
        HttpEntity entity = response.getEntity();
        int code = response.getStatusLine().getStatusCode();
        InputStream instream = null;
        try {
            if (code == 404) {
                instream = entity.getContent();
                instream.close();
                throw new AuthException("Authorization failed for user token: " + token);
            }
            if (code != 200) {
                this.adminToken = null;
                instream = entity.getContent();
                instream.close();
                String reasonPhrase = response.getStatusLine().getReasonPhrase();
                throw new AuthException("Failed to validate via HTTP " + code + " " + reasonPhrase);
            }
        }
        catch (IOException e) {
            throw new ClientProtocolException("IO Exception: problem closing stream ", (Throwable)e);
        }
        return this.parseResponse(response);
    }

    private HttpResponse sendPost(String uri, StringEntity body) throws ClientProtocolException {
        HttpResponse response = null;
        HttpPost post = new HttpPost(uri);
        post.setHeader("Accept", "application/json");
        post.setHeader("Content-Type", "application/json");
        try {
            post.setEntity((HttpEntity)body);
            response = this.client.execute((HttpUriRequest)post);
            int code = response.getStatusLine().getStatusCode();
            if (code != 201 && code != 200 && code != 203) {
                this.adminToken = null;
                throw new AdminAuthException("Failed to authenticate admin credentials " + code + response.getStatusLine().getReasonPhrase());
            }
        }
        catch (IOException e) {
            String message = e.getMessage() == null && e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            logger.error("Failure authenticating adminUser: {}", (Object)message);
            post.abort();
            throw new AdminAuthException("Failure authenticating adminUser :" + message, e);
        }
        return response;
    }

    private HttpResponse sendGet(String newUri, Header[] headers) throws ClientProtocolException {
        HttpResponse response = null;
        HttpGet get = null;
        get = new HttpGet(newUri);
        get.setHeader("Accept", "application/json");
        get.setHeader("Content-Type", "application/json");
        if (headers != null) {
            for (Header header : headers) {
                get.setHeader(header);
            }
        }
        if (this.appConfig.getAdminAuthMethod().equalsIgnoreCase("token")) {
            get.setHeader((Header)new BasicHeader("X-AUTH-TOKEN", this.appConfig.getAdminToken()));
        } else {
            get.setHeader((Header)new BasicHeader("X-AUTH-TOKEN", this.getAdminToken()));
        }
        try {
            response = this.client.execute((HttpUriRequest)get);
        }
        catch (ConnectException c) {
            get.abort();
            throw new ServiceUnavailableException(c.getMessage());
        }
        catch (IOException e) {
            get.abort();
            throw new ClientProtocolException("IO Exception during GET request ", (Throwable)e);
        }
        return response;
    }

    private String parseResponse(HttpResponse response) {
        StringBuffer json = new StringBuffer();
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try {
                InputStream instream = entity.getContent();
                BufferedReader reader = new BufferedReader(new InputStreamReader(instream));
                String line = reader.readLine();
                while (line != null) {
                    json.append(line);
                    line = reader.readLine();
                }
                instream.close();
                reader.close();
            }
            catch (Exception e) {
                throw new AuthException("Failed to parse Http Response ", e);
            }
        }
        return json.toString();
    }

    private String getAdminToken() throws ClientProtocolException {
        JsonParser jp = new JsonParser();
        if (this.adminTokenExpiry != null && this.isExpired(this.adminTokenExpiry)) {
            this.adminToken = null;
        }
        if (this.adminToken == null) {
            StringEntity params = this.getUnscopedV3AdminTokenRequest();
            String authUri = this.uri + "/v3/auth/tokens";
            HttpResponse response = this.sendPost(authUri, params);
            this.adminToken = response.getFirstHeader("X-Subject-Token").getValue();
            String json = this.parseResponse(response);
            JsonObject token = jp.parse(json).getAsJsonObject().get("token").getAsJsonObject();
            this.adminTokenExpiry = token.get("expires_at").getAsString();
        }
        return this.adminToken;
    }

    private String buildAuth(String userName, String password, String projectId, String projectName) {
        JsonObject domain = new JsonObject();
        domain.addProperty("id", "default");
        JsonObject user = new JsonObject();
        user.addProperty("name", userName);
        user.addProperty("password", password);
        user.add("domain", (JsonElement)domain);
        JsonObject passwordHolder = new JsonObject();
        passwordHolder.add("user", (JsonElement)user);
        JsonArray methods = new JsonArray();
        methods.add((JsonElement)new JsonPrimitive("password"));
        JsonObject identity = new JsonObject();
        identity.add("methods", (JsonElement)methods);
        identity.add("password", (JsonElement)passwordHolder);
        boolean scopeDefined = false;
        JsonObject project = new JsonObject();
        if (!projectId.isEmpty()) {
            project.addProperty("id", projectId);
            scopeDefined = true;
        } else if (!projectName.isEmpty()) {
            project.add("domain", (JsonElement)domain);
            project.addProperty("name", projectName);
            scopeDefined = true;
        }
        JsonObject auth = new JsonObject();
        auth.add("identity", (JsonElement)identity);
        if (scopeDefined) {
            JsonObject scope = new JsonObject();
            scope.add("project", (JsonElement)project);
            auth.add("scope", (JsonElement)scope);
        }
        JsonObject outer = new JsonObject();
        outer.add("auth", (JsonElement)auth);
        return outer.toString();
    }

    private StringEntity getUnscopedV3AdminTokenRequest() {
        if (!this.appConfig.getAdminAuthMethod().equalsIgnoreCase("password")) {
            String msg = String.format("Admin auth method %s not supported", this.appConfig.getAdminAuthMethod());
            throw new AdminAuthException(msg);
        }
        String body = this.buildAuth(this.appConfig.getAdminUser(), this.appConfig.getAdminPassword(), this.appConfig.getAdminProjectId(), this.appConfig.getAdminProjectName());
        try {
            return new StringEntity(body);
        }
        catch (UnsupportedEncodingException e) {
            throw new AdminAuthException("Invalid V3 authentication request " + e);
        }
    }

    private boolean isExpired(String expires) {
        Date tokenExpiryDate = null;
        try {
            String tmp = expires.replaceAll("\\.[\\d]+Z", "Z");
            tokenExpiryDate = expiryFormat.parse(tmp);
        }
        catch (ParseException e) {
            logger.warn("Failure parsing Admin Token expiration date: {}", (Object)e.getMessage());
            return true;
        }
        Date current = new Date();
        return tokenExpiryDate.getTime() < current.getTime() + 30000L;
    }

    public void reset() {
    }

    static {
        expiryFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

