/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.middleware;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import monasca.common.middleware.AdminAuthException;
import monasca.common.middleware.AuthConstants;
import monasca.common.middleware.AuthException;
import monasca.common.middleware.Config;
import monasca.common.middleware.FilterUtils;
import monasca.common.middleware.ServiceUnavailableException;
import monasca.common.middleware.TokenExceptionHandler;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuth
implements Filter,
AuthConstants {
    private static final String TOKEN_NOTFOUND = "Bad Request: Token not found in the request";
    private final Config appConfig = Config.getInstance();
    private FilterConfig filterConfig;
    private static final Logger logger = LoggerFactory.getLogger(TokenAuth.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        FilterUtils.destroyFilter();
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (((HttpServletRequest)req).getMethod().equals("OPTIONS")) {
            chain.doFilter(req, resp);
            return;
        }
        Object auth = null;
        int numberOfTries = 0;
        if (!this.appConfig.isInitialized()) {
            this.appConfig.initialize(this.filterConfig, req);
        }
        int retries = this.appConfig.getRetries();
        long pauseTime = this.appConfig.getPauseTime();
        String token = ((HttpServletRequest)req).getHeader("X-AUTH-TOKEN");
        if (token == null) {
            if (!this.appConfig.isDelayAuthDecision()) {
                logger.error("401 No token found.");
                ((HttpServletResponse)resp).sendError(401, TOKEN_NOTFOUND);
                return;
            }
            logger.info("No token found...Skipping");
        } else {
            do {
                try {
                    auth = FilterUtils.getCachedToken(token);
                }
                catch (ServiceUnavailableException e) {
                    if (numberOfTries < retries) {
                        FilterUtils.pause(pauseTime);
                        logger.debug("Retrying connection after " + pauseTime + " seconds.");
                        ++numberOfTries;
                        continue;
                    }
                    logger.debug("Exhausted retries..");
                    TokenExceptionHandler handler = TokenExceptionHandler.valueOf("ServiceUnavailableException");
                    handler.onException(e, resp, token);
                    return;
                }
                catch (ClientProtocolException e) {
                    if (numberOfTries < retries) {
                        FilterUtils.pause(pauseTime);
                        logger.debug("Retrying connection after " + pauseTime + " seconds.");
                        ++numberOfTries;
                        continue;
                    }
                    logger.debug("Exhausted retries..");
                    TokenExceptionHandler handler = TokenExceptionHandler.valueOf("ClientProtocolException");
                    handler.onException((Exception)((Object)e), resp, token);
                    return;
                }
                catch (UncheckedExecutionException e) {
                    TokenExceptionHandler handler;
                    Throwable toHandle;
                    if (e.getCause() != null && e.getCause() instanceof AdminAuthException) {
                        toHandle = (AdminAuthException)e.getCause();
                        handler = TokenExceptionHandler.valueOf("AdminAuthException");
                    } else if (e.getCause() != null && e.getCause() instanceof AuthException) {
                        toHandle = (AuthException)e.getCause();
                        handler = TokenExceptionHandler.valueOf("AuthException");
                    } else {
                        toHandle = e;
                        handler = TokenExceptionHandler.valueOf("UncheckedExecutionException");
                    }
                    handler.onException((Exception)toHandle, resp, token);
                    return;
                }
            } while (auth == null && numberOfTries <= retries);
        }
        req = FilterUtils.wrapRequest(req, auth);
        logger.debug("TokenAuth: Forwarding down stream to next filter/servlet");
        chain.doFilter(req, resp);
    }
}

