/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.middleware;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import monasca.common.middleware.AdminAuthException;
import monasca.common.middleware.AuthConnectionException;
import monasca.common.middleware.AuthException;
import monasca.common.middleware.ExceptionHandlerUtil;
import monasca.common.middleware.ServiceUnavailableException;
import org.apache.http.client.ClientProtocolException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TokenExceptionHandler {
    AuthConnectionException{

        @Override
        public void onException(Exception e, ServletResponse resp, String token) {
            AuthConnectionException ae = (AuthConnectionException)e;
            this.logger.error(ae.getMessage() + " " + ae);
            try {
                ((HttpServletResponse)resp).sendError(401, ExceptionHandlerUtil.getStatusText(401) + " " + token);
            }
            catch (IOException ie) {
                this.logger.debug("Error in writing the HTTP response " + ie.getMessage() + " " + ie);
            }
        }
    }
    ,
    TException{

        @Override
        public void onException(Exception e, ServletResponse resp, String token) {
            TException t = (TException)e;
            this.logger.error("Thrift Exception " + t.getMessage() + " " + t);
            try {
                ((HttpServletResponse)resp).sendError(401, ExceptionHandlerUtil.getStatusText(401) + " " + token);
            }
            catch (IOException ie) {
                this.logger.debug("Error in writing the HTTP response " + ie.getMessage() + " " + ie);
            }
        }
    }
    ,
    ClientProtocolException{

        @Override
        public void onException(Exception e, ServletResponse resp, String token) {
            ClientProtocolException t = (ClientProtocolException)e;
            this.logger.error("Http Client Exception " + t.getMessage() + " " + t);
            try {
                ((HttpServletResponse)resp).sendError(401, ExceptionHandlerUtil.getStatusText(401) + " " + token);
            }
            catch (IOException ie) {
                this.logger.debug("Error in writing the HTTP response " + ie.getMessage() + " " + ie);
            }
        }
    }
    ,
    UncheckedExecutionException{

        @Override
        public void onException(Exception e, ServletResponse resp, String token) {
            UncheckedExecutionException t = (UncheckedExecutionException)e;
            this.logger.error("Http Client Exception " + t.getMessage() + " " + t);
            try {
                ((HttpServletResponse)resp).sendError(401, ExceptionHandlerUtil.getStatusText(401) + " " + token);
            }
            catch (IOException ie) {
                this.logger.debug("Error in writing the HTTP response " + ie.getMessage() + " " + ie);
            }
        }
    }
    ,
    AdminAuthException{

        @Override
        public void onException(Exception e, ServletResponse resp, String token) {
            AdminAuthException ae = (AdminAuthException)e;
            this.logger.error(ae.getMessage() + " " + ae);
            String statusText = ExceptionHandlerUtil.getStatusText(500);
            try {
                ((HttpServletResponse)resp).sendError(500, statusText);
            }
            catch (IOException ie) {
                this.logger.debug("Error in writing the HTTP response " + ie.getMessage() + " " + ie);
            }
        }
    }
    ,
    AuthException{

        @Override
        public void onException(Exception e, ServletResponse resp, String token) {
            AuthException ae = (AuthException)e;
            this.logger.info(ae.getMessage() + " " + ae);
            String statusText = ae.getMessage();
            if (statusText == null || statusText.isEmpty()) {
                statusText = ExceptionHandlerUtil.getStatusText(401);
            }
            try {
                ((HttpServletResponse)resp).sendError(401, statusText + " " + token);
            }
            catch (IOException ie) {
                this.logger.debug("Error in writing the HTTP response " + ie.getMessage() + " " + ie);
            }
        }
    }
    ,
    ServiceUnavailableException{

        @Override
        public void onException(Exception e, ServletResponse resp, String token) {
            ServiceUnavailableException ae = (ServiceUnavailableException)e;
            this.logger.error(ae.getMessage() + " " + ae);
            String statusText = ae.getMessage();
            if (statusText == null || statusText.isEmpty()) {
                statusText = ExceptionHandlerUtil.getStatusText(401);
            }
            try {
                ((HttpServletResponse)resp).sendError(401, statusText + " " + token);
            }
            catch (IOException ie) {
                this.logger.debug("Error in writing the HTTP response " + ie.getMessage() + " " + ie);
            }
        }
    };

    final Logger logger = LoggerFactory.getLogger(TokenExceptionHandler.class);

    abstract void onException(Exception var1, ServletResponse var2, String var3);
}

