/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.middleware;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import monasca.common.middleware.AdminAuthException;
import monasca.common.middleware.AuthClientFactory;
import monasca.common.middleware.AuthConstants;
import monasca.common.middleware.TokenCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config
implements AuthConstants {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private static final Config instance = new Config();
    public static final String TOKEN = "token";
    public static final String PASSWORD = "password";
    private ServletContext context = null;
    private TokenCache client = null;
    private AuthClientFactory factory = null;
    private long timeToCacheToken;
    private boolean delayAuthDecision;
    private int retries;
    private int pauseTime;
    private boolean includeCatalog;
    private String adminAuthMethod;
    private String adminProjectId;
    private String adminProjectName;
    private String adminUserDomainId;
    private String adminUserDomainName;
    private String adminProjectDomainId;
    private String adminProjectDomainName;
    private volatile boolean initialized = false;
    private FilterConfig filterConfig;

    private Config() {
    }

    public static Config getInstance() {
        return instance;
    }

    public synchronized void initialize(FilterConfig config, ServletRequest req) throws ServletException {
        this.context = config.getServletContext();
        this.filterConfig = config;
        try {
            String host = this.filterConfig.getInitParameter("ServerVIP");
            int port = Integer.parseInt(this.filterConfig.getInitParameter("ServerPort"));
            String keyStore = this.filterConfig.getInitParameter("Keystore");
            String keyPass = this.filterConfig.getInitParameter("KeystorePass");
            String trustStore = this.filterConfig.getInitParameter("Truststore");
            String trustPass = this.filterConfig.getInitParameter("TruststorePass");
            String adminToken = this.getValue("AdminToken", "");
            boolean useHttps = this.getValue("UseHttps", false);
            int timeout = this.getValue("ConnTimeout", 0);
            boolean clientAuth = this.getValue("ConnSSLClientAuth", true);
            int maxActive = this.getValue("ConnPoolMaxActive", 3);
            int maxIdle = this.getValue("ConnPoolMaxIdle", 3);
            long evictPeriod = this.getValue("ConnPoolEvictPeriod", 60000L);
            long minIdleTime = this.getValue("ConnPoolMinIdleTime", 90000L);
            this.retries = this.getValue("ConnRetryTimes", 3);
            this.pauseTime = this.getValue("ConnRetryInterval", 100);
            this.delayAuthDecision = this.getValue("DelayAuthDecision", false);
            this.includeCatalog = this.getValue("IncludeServiceCatalog", true);
            this.adminAuthMethod = this.getValue("AdminAuthMethod", "");
            this.adminProjectId = this.getValue("AdminProjectId", "");
            this.adminProjectName = this.getValue("AdminProjectName", "");
            this.adminUserDomainId = this.getValue("AdminUserDomainId", "");
            this.adminUserDomainName = this.getValue("AdminUserDomainName", "");
            this.adminProjectDomainId = this.getValue("AdminProjectDomainId", "");
            this.adminProjectDomainName = this.getValue("AdminProjectDomainName", "");
            this.timeToCacheToken = this.getValue("TimeToCacheToken", 600).intValue();
            long maxTokenCacheSize = this.getValue("MaxTokenCacheSize", 0x100000).intValue();
            this.factory = AuthClientFactory.build(host, port, useHttps, timeout, clientAuth, keyStore, keyPass, trustStore, trustPass, maxActive, maxIdle, evictPeriod, minIdleTime, adminToken);
            this.verifyRequiredParamsForAuthMethod();
            this.client = new TokenCache(maxTokenCacheSize, this.timeToCacheToken);
            logger.info("Using https {}", (Object)useHttps);
            if (useHttps) {
                logger.info("Auth host (2-way SSL: " + clientAuth + "): " + host);
            }
            logger.info("Read Servlet Initialization Parameters ");
            this.initialized = true;
        }
        catch (Throwable t) {
            logger.error("Failure initializing connection to authentication endpoint : {}", (Object)t.getMessage());
            throw new ServletException("Failure initializing connection to authentication endpoint  :: " + t.getMessage(), t);
        }
    }

    private boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected String getAdminProjectId() {
        return this.adminProjectId;
    }

    protected String getAdminProjectName() {
        return this.adminProjectName;
    }

    protected String getAdminUserDomainId() {
        return this.adminUserDomainId;
    }

    protected String getAdminUserDomainName() {
        return this.adminUserDomainName;
    }

    protected String getAdminProjectDomainId() {
        return this.adminProjectDomainId;
    }

    protected String getAdminProjectDomainName() {
        return this.adminProjectDomainName;
    }

    protected String getAdminAccessKey() {
        if (this.context.getAttribute("AdminAccessKey") != null) {
            return (String)this.context.getAttribute("AdminAccessKey");
        }
        return this.getValue("AdminAccessKey", "");
    }

    protected String getAdminSecretKey() {
        if (this.context.getAttribute("AdminSecretKey") != null) {
            return (String)this.context.getAttribute("AdminSecretKey");
        }
        return this.getValue("AdminSecretKey", "");
    }

    protected String getAdminToken() {
        return this.getValue("AdminToken", "");
    }

    protected String getAdminAuthMethod() {
        return this.adminAuthMethod;
    }

    protected String getAdminUser() {
        if (this.context.getAttribute("AdminUser") != null) {
            return (String)this.context.getAttribute("AdminUser");
        }
        return this.getValue("AdminUser", "");
    }

    protected String getAdminPassword() {
        if (this.context.getAttribute("AdminPassword") != null) {
            String password = (String)this.context.getAttribute("AdminPassword");
            return password;
        }
        return this.getValue("AdminPassword", "");
    }

    protected boolean isIncludeCatalog() {
        return this.includeCatalog;
    }

    protected ServletContext getConfig() {
        return this.context;
    }

    protected TokenCache getClient() {
        return this.client;
    }

    protected AuthClientFactory getFactory() {
        return this.factory;
    }

    protected boolean isDelayAuthDecision() {
        return this.delayAuthDecision;
    }

    protected int getRetries() {
        return this.retries;
    }

    protected int getPauseTime() {
        return this.pauseTime;
    }

    public long getTimeToCacheToken() {
        return this.timeToCacheToken;
    }

    public void setTimeToCacheToken(long timeToCachedToken) {
        this.timeToCacheToken = timeToCachedToken;
    }

    public void setClient(TokenCache client) {
        this.client = client;
    }

    private <T> T getValue(String paramName, T defaultValue) {
        Class<?> type = defaultValue.getClass();
        String initparamValue = this.filterConfig.getInitParameter(paramName);
        if (!this.isEmpty(initparamValue)) {
            if (type.equals(Integer.class)) {
                int paramValue = Integer.parseInt(initparamValue);
                return (T)type.cast(paramValue);
            }
            if (type.equals(Long.class)) {
                long paramValue = Long.parseLong(initparamValue);
                return (T)type.cast(paramValue);
            }
            if (type.equals(Boolean.class)) {
                boolean paramValue = Boolean.parseBoolean(initparamValue);
                return (T)type.cast(paramValue);
            }
            if (type.equals(String.class)) {
                return (T)type.cast(initparamValue);
            }
        }
        return defaultValue;
    }

    private void verifyRequiredParamsForAuthMethod() {
        if (this.isEmpty(this.getAdminAuthMethod()) || this.getAdminAuthMethod().equalsIgnoreCase(TOKEN)) {
            if (this.isEmpty(this.getAdminToken())) {
                throw new AdminAuthException(String.format("adminToken must be set if adminAuthMethod is %s.", TOKEN));
            }
        } else if (this.getAdminAuthMethod().equalsIgnoreCase(PASSWORD)) {
            if (this.isEmpty(this.getAdminUser()) || this.isEmpty(this.getAdminPassword())) {
                throw new AdminAuthException(String.format("adminUser and adminPassword must be set if adminAuthMethod is %s.", PASSWORD));
            }
        } else {
            throw new AdminAuthException(String.format("Unrecognized value '%s' for adminAuthMethod. Valid values are %s or %s", this.getAdminAuthMethod(), TOKEN, PASSWORD));
        }
    }
}

