/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.middleware;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletRequest;
import monasca.common.middleware.AuthClientFactory;
import monasca.common.middleware.AuthConstants;
import monasca.common.middleware.Config;
import monasca.common.middleware.TokenCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterUtils {
    private static final Config appConfig = Config.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(FilterUtils.class);

    private FilterUtils() {
    }

    public static void destroyFilter() {
        AuthClientFactory factory;
        TokenCache client = appConfig.getClient();
        if (client != null) {
            appConfig.setClient(null);
        }
        if ((factory = appConfig.getFactory()) != null) {
            factory.shutdown();
        }
    }

    public static ServletRequest wrapRequestFromHttpResponse(ServletRequest req, String data) {
        FilterUtils.wrapRequestFromHttpV3Response(req, data);
        return req;
    }

    private static void wrapRequestFromHttpV3Response(ServletRequest req, String data) {
        String nonTenantRoles;
        JsonArray roles;
        StringBuilder tenants = new StringBuilder();
        StringBuilder nonTenants = new StringBuilder();
        JsonParser jp = new JsonParser();
        JsonObject token = jp.parse(data).getAsJsonObject().get("token").getAsJsonObject();
        if (token.get("domain") != null) {
            JsonObject domain = token.get("domain").getAsJsonObject();
            req.setAttribute("X-DOMAIN-ID", (Object)domain.get("id").getAsString());
            if (domain.get("name") != null) {
                req.setAttribute("X-DOMAIN-NAME", (Object)domain.get("name").getAsString());
            }
        }
        if (token.get("project") != null) {
            JsonObject project = token.get("project").getAsJsonObject();
            req.setAttribute("X-PROJECT-ID", (Object)project.get("id").getAsString());
            req.setAttribute("X-PROJECT-NAME", (Object)project.get("name").getAsString());
            JsonObject projectDomain = project.get("domain").getAsJsonObject();
            if (!projectDomain.get("id").equals(JsonNull.INSTANCE)) {
                req.setAttribute("X-PROJECT-DOMAIN-ID", (Object)projectDomain.get("id").getAsString());
            }
            if (projectDomain.get("name") != null) {
                req.setAttribute("X-PROJECT-DOMAIN-NAME", (Object)projectDomain.get("name"));
            }
        }
        if (token.get("user") != null) {
            JsonObject user = token.get("user").getAsJsonObject();
            req.setAttribute("X-USER-ID", (Object)user.get("id").getAsString());
            req.setAttribute("X-USER-NAME", (Object)user.get("name").getAsString());
            JsonObject userDomain = user.get("domain").getAsJsonObject();
            if (userDomain.get("id") != null) {
                req.setAttribute("X-USER-DOMAIN-ID", (Object)userDomain.get("id").getAsString());
            }
            if (userDomain.get("name") != null) {
                req.setAttribute("X-USER-DOMAIN-NAME", (Object)userDomain.get("name").getAsString());
            }
        }
        if ((roles = token.getAsJsonArray("roles")) != null) {
            Iterator it = roles.iterator();
            StringBuilder roleBuilder = new StringBuilder();
            while (it.hasNext()) {
                JsonObject role = ((JsonElement)it.next()).getAsJsonObject();
                String currentRole = role.get("name").getAsString();
                roleBuilder.append(currentRole).append(",");
            }
            req.setAttribute("X-ROLES", (Object)roleBuilder.toString());
        }
        String tenantRoles = tenants.length() > 0 ? tenants.substring(1) : tenants.toString();
        String string = nonTenantRoles = nonTenants.length() > 0 ? nonTenants.substring(1) : nonTenants.toString();
        if (!tenantRoles.equals("")) {
            req.setAttribute("X-ROLES", (Object)tenantRoles);
        }
        if (!nonTenantRoles.equals("")) {
            req.setAttribute("X-HP-IDM-Non-Tenant-Roles", (Object)nonTenantRoles);
        }
        if (token.get("catalog") != null && appConfig.isIncludeCatalog()) {
            JsonArray catalog = token.get("catalog").getAsJsonArray();
            req.setAttribute("X-SERVICE-CATALOG", (Object)catalog.toString());
        }
    }

    public static ServletRequest wrapRequest(ServletRequest req, Object data) {
        if (data == null) {
            req.setAttribute("X-IDENTITY-STATUS", (Object)AuthConstants.IdentityStatus.Invalid.toString());
            logger.debug("Failed Authentication. Setting identity status header to Invalid");
        }
        req.setAttribute("X-IDENTITY-STATUS", (Object)AuthConstants.IdentityStatus.Confirmed.toString());
        if (data instanceof String) {
            FilterUtils.wrapRequestFromHttpResponse(req, (String)data);
        }
        return req;
    }

    public static void cacheToken(String token, Object auth) {
        appConfig.getClient().put(token, (String)auth);
    }

    public static Object getCachedToken(String token) throws IOException {
        return appConfig.getClient().getToken(token);
    }

    public static void pause(long pauseTime) {
        try {
            Thread.sleep(pauseTime * 1000L);
        }
        catch (InterruptedException e) {
            logger.debug("Thread is interrupted while sleeping before " + pauseTime + " seconds. ");
        }
    }
}

