/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.middleware;

import monasca.common.middleware.AuthClient;
import monasca.common.middleware.AuthConnectionException;
import monasca.common.middleware.HttpClientFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public abstract class AuthClientFactory {
    private static AuthClientFactory instance = null;
    protected static GenericObjectPool<AuthClient> pool;

    public static synchronized AuthClientFactory build(String host, int port, boolean useHttps, int timeout, boolean clientAuth, String keyStore, String keyPass, String trustStore, String trustPass, int maxActive, int maxIdle, long timeBetweenEvictionRunsMillis, long minEvictableIdleTimeMillis, String adminToken) throws Exception {
        if (instance == null) {
            instance = new HttpClientFactory(host, port, useHttps, timeout, clientAuth, keyStore, keyPass, trustStore, trustPass, adminToken, maxActive, timeBetweenEvictionRunsMillis, minEvictableIdleTimeMillis);
            pool.setMaxActive(maxActive);
            pool.setMaxIdle(maxIdle);
            pool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
            pool.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
        }
        return instance;
    }

    public AuthClient getClient() {
        try {
            return (AuthClient)pool.borrowObject();
        }
        catch (Exception e) {
            throw new AuthConnectionException("Failed to get a client " + e.getMessage(), e);
        }
    }

    public void recycle(AuthClient client) {
        try {
            pool.returnObject((Object)client);
        }
        catch (Exception e) {
            throw new AuthConnectionException("Failed to recycle client", e);
        }
    }

    public void discard(AuthClient client) {
        try {
            pool.invalidateObject((Object)client);
        }
        catch (Exception e) {
            System.out.println("AuthConnection problem destorying");
            throw new AuthConnectionException("Failed to destroy client", e);
        }
    }

    public void shutdown() {
        try {
            pool.close();
        }
        catch (Exception e) {
            throw new AuthConnectionException("Failed to close client pool", e);
        }
    }
}

