/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.middleware;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import monasca.common.middleware.AuthClient;
import monasca.common.middleware.AuthClientFactory;
import monasca.common.middleware.Config;
import org.apache.http.client.ClientProtocolException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCache {
    private final LoadingCache<String, String> cache;
    private final Config appConfig = Config.getInstance();
    private AuthClientFactory factory = this.appConfig.getFactory();
    private static final Logger logger = LoggerFactory.getLogger(TokenCache.class);

    public TokenCache(long maxSize, long timeToExpire) {
        this.cache = CacheBuilder.newBuilder().maximumSize(maxSize).expireAfterWrite(timeToExpire, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws TException, ClientProtocolException {
                String value = null;
                AuthClient client = null;
                boolean discarded = false;
                try {
                    client = TokenCache.this.factory.getClient();
                    value = client.validateTokenForServiceEndpointV3(key);
                }
                catch (ClientProtocolException e) {
                    TokenCache.this.factory.discard(client);
                    logger.warn("Validate token failed with ClientProtocolException. Discarding AuthClient connection from pool to create a new connection.");
                    logger.warn("ClientProtocolException " + e.getMessage() + " " + (Object)((Object)e));
                    discarded = true;
                    throw e;
                }
                finally {
                    if (client != null && !discarded) {
                        TokenCache.this.factory.recycle(client);
                    }
                }
                return value;
            }
        });
    }

    public String getToken(String key) throws ClientProtocolException {
        String value = null;
        try {
            value = (String)this.cache.get((Object)key);
        }
        catch (ExecutionException e) {
            logger.info("Failed to get token", (Throwable)e);
            throw new ClientProtocolException(e.getMessage(), (Throwable)e);
        }
        return value;
    }

    public void put(String key, String value) {
        this.cache.put((Object)key, (Object)value);
    }
}

