/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.middleware;

import monasca.common.middleware.TokenExceptionHandler;

public class ExceptionHandlerUtil {
    public static final String SERVICE_UNAVAILABLE = "Service Unavailable";
    public static final String UNAUTHORIZED_TOKEN = "Unauthorized Token";
    public static final String INTERNAL_SERVER_ERROR = "Internal Server Error";

    private ExceptionHandlerUtil() {
    }

    public static String getStatusText(int errorCode) {
        if (errorCode == 401) {
            return UNAUTHORIZED_TOKEN;
        }
        if (errorCode == 503) {
            return SERVICE_UNAVAILABLE;
        }
        if (errorCode == 500) {
            return INTERNAL_SERVER_ERROR;
        }
        return "Unknown Error";
    }

    public static TokenExceptionHandler lookUpTokenException(Exception ex) {
        try {
            return TokenExceptionHandler.valueOf(ex.getClass().getSimpleName());
        }
        catch (IllegalArgumentException iae) {
            return TokenExceptionHandler.valueOf("ResourceException");
        }
    }
}

