/*
 * Decompiled with CFR 0.152.
 */
package monasca.common.middleware;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URI;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import monasca.common.middleware.AuthConnectionException;
import monasca.common.middleware.HttpAuthClient;
import monasca.common.middleware.HttpPoolCleaner;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientPoolFactory
extends BasePoolableObjectFactory<Object> {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientPoolFactory.class);
    private URI uri;
    private PoolingClientConnectionManager connMgr;
    private HttpPoolCleaner cleaner;
    private HttpClient client;

    HttpClientPoolFactory(String host, int port, boolean useHttps, int timeout, boolean clientAuth, String keyStore, String keyPass, String trustStore, String trustPass, String adminToken, int maxActive, long timeBetweenEvictionRunsMillis, long minEvictableIdleTimeMillis) {
        String protocol = useHttps ? "https://" : "http://";
        String urlStr = protocol + host + ":" + port;
        this.uri = URI.create(urlStr);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        if (protocol.startsWith("https")) {
            SSLSocketFactory sslf = HttpClientPoolFactory.sslFactory(keyStore, keyPass, trustStore, trustPass, clientAuth);
            schemeRegistry.register(new Scheme("https", port, (SchemeSocketFactory)sslf));
        } else {
            schemeRegistry.register(new Scheme("http", port, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        }
        this.connMgr = new PoolingClientConnectionManager(schemeRegistry, minEvictableIdleTimeMillis, TimeUnit.MILLISECONDS);
        this.connMgr.setMaxTotal(maxActive);
        this.connMgr.setDefaultMaxPerRoute(maxActive);
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.socket.timeout", (Object)timeout);
        params.setParameter("http.connection.timeout", (Object)timeout);
        this.client = new DefaultHttpClient((ClientConnectionManager)this.connMgr, (HttpParams)params);
        this.cleaner = new HttpPoolCleaner((ClientConnectionManager)this.connMgr, timeBetweenEvictionRunsMillis, minEvictableIdleTimeMillis);
        new Thread(this.cleaner).start();
    }

    public Object makeObject() throws Exception {
        return new HttpAuthClient(this.client, this.uri);
    }

    public void passivateObject(Object obj) throws Exception {
        ((HttpAuthClient)obj).reset();
    }

    public void destroyObject(Object obj) throws Exception {
        ((HttpAuthClient)obj).reset();
        obj = null;
    }

    public void shutDown() {
        this.connMgr.shutdown();
        this.cleaner.shutdown();
    }

    private static SSLSocketFactory sslFactory(String keyStore, String keyPass, String trustStore, String trustPass, boolean clientAuth) {
        try {
            KeyStore ks = null;
            if (clientAuth) {
                ks = HttpClientPoolFactory.loadKeystore("keystore", keyStore, keyPass);
            }
            KeyStore ts = HttpClientPoolFactory.loadKeystore("truststore", trustStore, trustPass);
            SSLSocketFactory sslf = new SSLSocketFactory(ks, keyPass, ts);
            return sslf;
        }
        catch (Exception e) {
            throw new AuthConnectionException("Failed to create SSLSocketFactory: " + e.getMessage(), e);
        }
    }

    private static KeyStore loadKeystore(String type, String keyStore, String keyPass) throws Exception {
        KeyStore ks;
        block16: {
            ks = KeyStore.getInstance("jks");
            if (keyStore != null && !keyStore.isEmpty()) {
                File keystoreFile = new File(keyStore);
                if (!keystoreFile.canRead()) {
                    throw new FileNotFoundException(String.format("%s '%s' is not readable", type, keyStore));
                }
                try (FileInputStream is1 = new FileInputStream(keystoreFile);){
                    ks.load(is1, keyPass.toCharArray());
                    break block16;
                }
                catch (Exception e) {
                    String errorMessage = String.format("Unable to open %s '%s': %s", type, keyStore, e.getMessage());
                    logger.error(errorMessage);
                    throw new Exception(errorMessage, e);
                }
            }
            ks.load(null, null);
        }
        return ks;
    }
}

